/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.LegacyAddress;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.HDUtils;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.LinuxSecureRandom;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.script.ScriptPattern;
import org.bitcoinj.utils.ListenerRegistration;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.AllRandomKeysRotating;
import org.bitcoinj.wallet.BasicKeyChain;
import org.bitcoinj.wallet.DefaultKeyChainFactory;
import org.bitcoinj.wallet.DeterministicKeyChain;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.DeterministicUpgradeRequiredException;
import org.bitcoinj.wallet.DeterministicUpgradeRequiresPassword;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.KeyChain;
import org.bitcoinj.wallet.KeyChainFactory;
import org.bitcoinj.wallet.KeyChainGroupStructure;
import org.bitcoinj.wallet.MarriedKeyChain;
import org.bitcoinj.wallet.Protos;
import org.bitcoinj.wallet.RedeemData;
import org.bitcoinj.wallet.UnreadableWalletException;
import org.bitcoinj.wallet.listeners.KeyChainEventListener;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyChainGroup
implements KeyBag {
    private static final Logger log;
    private BasicKeyChain basic;
    private final NetworkParameters params;
    @Nullable
    protected final LinkedList<DeterministicKeyChain> chains;
    private final EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys;
    private final EnumMap<KeyChain.KeyPurpose, Address> currentAddresses;
    @Nullable
    private KeyCrypter keyCrypter;
    private int lookaheadSize = -1;
    private int lookaheadThreshold = -1;

    public static KeyChainGroup createBasic(NetworkParameters params) {
        return new KeyChainGroup(params, new BasicKeyChain(), null, -1, -1, null, null);
    }

    public static Builder builder(NetworkParameters params) {
        return new Builder(params, KeyChainGroupStructure.DEFAULT);
    }

    public static Builder builder(NetworkParameters params, KeyChainGroupStructure structure) {
        return new Builder(params, structure);
    }

    private KeyChainGroup(NetworkParameters params, @Nullable BasicKeyChain basicKeyChain, @Nullable List<DeterministicKeyChain> chains, int lookaheadSize, int lookaheadThreshold, @Nullable EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys, @Nullable KeyCrypter crypter) {
        this.params = params;
        BasicKeyChain basicKeyChain2 = this.basic = basicKeyChain == null ? new BasicKeyChain() : basicKeyChain;
        if (chains != null) {
            if (lookaheadSize > -1) {
                this.lookaheadSize = lookaheadSize;
            } else if (params.getId().equals("org.bitcoinj.unittest")) {
                this.lookaheadSize = 5;
            }
            if (lookaheadThreshold > -1) {
                this.lookaheadThreshold = lookaheadThreshold;
            }
            this.chains = new LinkedList<DeterministicKeyChain>(chains);
            for (DeterministicKeyChain deterministicKeyChain : this.chains) {
                if (this.lookaheadSize > -1) {
                    deterministicKeyChain.setLookaheadSize(this.lookaheadSize);
                }
                if (this.lookaheadThreshold <= -1) continue;
                deterministicKeyChain.setLookaheadThreshold(this.lookaheadThreshold);
            }
        } else {
            this.chains = null;
        }
        this.keyCrypter = crypter;
        this.currentKeys = currentKeys == null ? new EnumMap(KeyChain.KeyPurpose.class) : currentKeys;
        this.currentAddresses = new EnumMap(KeyChain.KeyPurpose.class);
        if (this.isMarried()) {
            this.maybeLookaheadScripts();
            for (Map.Entry entry : this.currentKeys.entrySet()) {
                Address address = ScriptBuilder.createP2SHOutputScript(this.getActiveKeyChain().getRedeemData((DeterministicKey)((DeterministicKey)entry.getValue())).redeemScript).getToAddress(params);
                this.currentAddresses.put((KeyChain.KeyPurpose)((Enum)entry.getKey()), address);
            }
        }
    }

    public boolean isSupportsDeterministicChains() {
        return this.chains != null;
    }

    private void maybeLookaheadScripts() {
        for (DeterministicKeyChain chain : this.chains) {
            chain.maybeLookAheadScripts();
        }
    }

    public void addAndActivateHDChain(DeterministicKeyChain chain) {
        Preconditions.checkState((boolean)this.isSupportsDeterministicChains(), (Object)"doesn't support deterministic chains");
        log.info("Activating a new HD chain: {}", (Object)chain);
        for (ListenerRegistration<KeyChainEventListener> registration : this.basic.getListeners()) {
            chain.addEventListener((KeyChainEventListener)registration.listener, registration.executor);
        }
        if (this.lookaheadSize >= 0) {
            chain.setLookaheadSize(this.lookaheadSize);
        }
        if (this.lookaheadThreshold >= 0) {
            chain.setLookaheadThreshold(this.lookaheadThreshold);
        }
        this.chains.add(chain);
        this.currentKeys.clear();
        this.currentAddresses.clear();
    }

    public DeterministicKey currentKey(KeyChain.KeyPurpose purpose) {
        DeterministicKeyChain chain = this.getActiveKeyChain();
        if (chain.isMarried()) {
            throw new UnsupportedOperationException("Key is not suitable to receive coins for married keychains. Use freshAddress to get P2SH address instead");
        }
        DeterministicKey current = this.currentKeys.get((Object)purpose);
        if (current == null) {
            current = this.freshKey(purpose);
            this.currentKeys.put(purpose, current);
        }
        return current;
    }

    public Address currentAddress(KeyChain.KeyPurpose purpose) {
        DeterministicKeyChain chain = this.getActiveKeyChain();
        Script.ScriptType outputScriptType = chain.getOutputScriptType();
        if (chain.isMarried()) {
            Address current = this.currentAddresses.get((Object)purpose);
            if (current == null) {
                current = this.freshAddress(purpose);
                this.currentAddresses.put(purpose, current);
            }
            return current;
        }
        if (outputScriptType == Script.ScriptType.P2PKH || outputScriptType == Script.ScriptType.P2WPKH) {
            return Address.fromKey(this.params, this.currentKey(purpose), outputScriptType);
        }
        throw new IllegalStateException(chain.getOutputScriptType().toString());
    }

    public DeterministicKey freshKey(KeyChain.KeyPurpose purpose) {
        return this.freshKeys(purpose, 1).get(0);
    }

    public List<DeterministicKey> freshKeys(KeyChain.KeyPurpose purpose, int numberOfKeys) {
        DeterministicKeyChain chain = this.getActiveKeyChain();
        if (chain.isMarried()) {
            throw new UnsupportedOperationException("Key is not suitable to receive coins for married keychains. Use freshAddress to get P2SH address instead");
        }
        return chain.getKeys(purpose, numberOfKeys);
    }

    public Address freshAddress(KeyChain.KeyPurpose purpose, Script.ScriptType outputScriptType, long keyRotationTimeSecs) {
        DeterministicKeyChain chain = this.getActiveKeyChain(outputScriptType, keyRotationTimeSecs);
        return Address.fromKey(this.params, chain.getKey(purpose), outputScriptType);
    }

    public Address freshAddress(KeyChain.KeyPurpose purpose) {
        DeterministicKeyChain chain = this.getActiveKeyChain();
        Script.ScriptType outputScriptType = chain.getOutputScriptType();
        if (chain.isMarried()) {
            Script outputScript = chain.freshOutputScript(purpose);
            Preconditions.checkState((boolean)ScriptPattern.isP2SH(outputScript));
            LegacyAddress freshAddress = LegacyAddress.fromScriptHash(this.params, ScriptPattern.extractHashFromP2SH(outputScript));
            this.maybeLookaheadScripts();
            this.currentAddresses.put(purpose, freshAddress);
            return freshAddress;
        }
        if (outputScriptType == Script.ScriptType.P2PKH || outputScriptType == Script.ScriptType.P2WPKH) {
            return Address.fromKey(this.params, this.freshKey(purpose), outputScriptType);
        }
        throw new IllegalStateException(chain.getOutputScriptType().toString());
    }

    public List<DeterministicKeyChain> getActiveKeyChains(long keyRotationTimeSecs) {
        Preconditions.checkState((boolean)this.isSupportsDeterministicChains(), (Object)"doesn't support deterministic chains");
        LinkedList<DeterministicKeyChain> activeChains = new LinkedList<DeterministicKeyChain>();
        for (DeterministicKeyChain chain : this.chains) {
            if (chain.getEarliestKeyCreationTime() < keyRotationTimeSecs) continue;
            activeChains.add(chain);
        }
        return activeChains;
    }

    public final DeterministicKeyChain getActiveKeyChain(Script.ScriptType outputScriptType, long keyRotationTimeSecs) {
        Preconditions.checkState((boolean)this.isSupportsDeterministicChains(), (Object)"doesn't support deterministic chains");
        for (DeterministicKeyChain chain : ImmutableList.copyOf(this.chains).reverse()) {
            if (chain.getOutputScriptType() != outputScriptType || chain.getEarliestKeyCreationTime() < keyRotationTimeSecs) continue;
            return chain;
        }
        return null;
    }

    public final DeterministicKeyChain getActiveKeyChain() {
        Preconditions.checkState((boolean)this.isSupportsDeterministicChains(), (Object)"doesn't support deterministic chains");
        if (this.chains.isEmpty()) {
            throw new DeterministicUpgradeRequiredException();
        }
        return this.chains.get(this.chains.size() - 1);
    }

    public final void mergeActiveKeyChains(KeyChainGroup from, long keyRotationTimeSecs) {
        Preconditions.checkArgument((this.isEncrypted() == from.isEncrypted() ? 1 : 0) != 0, (Object)"encrypted and non-encrypted keychains cannot be mixed");
        for (DeterministicKeyChain chain : from.getActiveKeyChains(keyRotationTimeSecs)) {
            this.addAndActivateHDChain(chain);
        }
    }

    public int getLookaheadSize() {
        Preconditions.checkState((boolean)this.isSupportsDeterministicChains(), (Object)"doesn't support deterministic chains");
        if (this.lookaheadSize == -1) {
            return this.getActiveKeyChain().getLookaheadSize();
        }
        return this.lookaheadSize;
    }

    public int getLookaheadThreshold() {
        Preconditions.checkState((boolean)this.isSupportsDeterministicChains(), (Object)"doesn't support deterministic chains");
        if (this.lookaheadThreshold == -1) {
            return this.getActiveKeyChain().getLookaheadThreshold();
        }
        return this.lookaheadThreshold;
    }

    public int importKeys(List<ECKey> keys) {
        return this.basic.importKeys(keys);
    }

    public int importKeys(ECKey ... keys) {
        return this.importKeys((List<ECKey>)ImmutableList.copyOf((Object[])keys));
    }

    public boolean checkPassword(CharSequence password) {
        Preconditions.checkState((this.keyCrypter != null ? 1 : 0) != 0, (Object)"Not encrypted");
        return this.checkAESKey(this.keyCrypter.deriveKey(password));
    }

    public boolean checkAESKey(KeyParameter aesKey) {
        Preconditions.checkState((this.keyCrypter != null ? 1 : 0) != 0, (Object)"Not encrypted");
        if (this.basic.numKeys() > 0) {
            return this.basic.checkAESKey(aesKey);
        }
        return this.getActiveKeyChain().checkAESKey(aesKey);
    }

    public int importKeysAndEncrypt(List<ECKey> keys, KeyParameter aesKey) {
        Preconditions.checkState((this.keyCrypter != null ? 1 : 0) != 0, (Object)"Not encrypted");
        LinkedList encryptedKeys = Lists.newLinkedList();
        for (ECKey key : keys) {
            if (key.isEncrypted()) {
                throw new IllegalArgumentException("Cannot provide already encrypted keys");
            }
            encryptedKeys.add(key.encrypt(this.keyCrypter, aesKey));
        }
        return this.importKeys(encryptedKeys);
    }

    @Override
    @Nullable
    public RedeemData findRedeemDataFromScriptHash(byte[] scriptHash) {
        Iterator<DeterministicKeyChain> iter = this.chains.descendingIterator();
        while (iter.hasNext()) {
            DeterministicKeyChain chain = iter.next();
            RedeemData redeemData = chain.findRedeemDataByScriptHash(ByteString.copyFrom((byte[])scriptHash));
            if (redeemData == null) continue;
            return redeemData;
        }
        return null;
    }

    public void markP2SHAddressAsUsed(LegacyAddress address) {
        Preconditions.checkArgument((address.getOutputScriptType() == Script.ScriptType.P2SH ? 1 : 0) != 0);
        RedeemData data = this.findRedeemDataFromScriptHash(address.getHash());
        if (data == null) {
            return;
        }
        for (ECKey key : data.keys) {
            for (DeterministicKeyChain chain : this.chains) {
                DeterministicKey k = chain.findKeyFromPubKey(key.getPubKey());
                if (k == null) continue;
                chain.markKeyAsUsed(k);
                this.maybeMarkCurrentAddressAsUsed(address);
            }
        }
    }

    @Override
    @Nullable
    public ECKey findKeyFromPubKeyHash(byte[] pubKeyHash, @Nullable Script.ScriptType scriptType) {
        ECKey result = this.basic.findKeyFromPubHash(pubKeyHash);
        if (result != null) {
            return result;
        }
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                if (scriptType != null && scriptType != chain.getOutputScriptType() || (result = chain.findKeyFromPubHash(pubKeyHash)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public void markPubKeyHashAsUsed(byte[] pubKeyHash) {
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                DeterministicKey key = chain.markPubHashAsUsed(pubKeyHash);
                if (key == null) continue;
                this.maybeMarkCurrentKeyAsUsed(key);
                return;
            }
        }
    }

    private void maybeMarkCurrentAddressAsUsed(LegacyAddress address) {
        Preconditions.checkArgument((address.getOutputScriptType() == Script.ScriptType.P2SH ? 1 : 0) != 0);
        for (Map.Entry<KeyChain.KeyPurpose, Address> entry : this.currentAddresses.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(address)) continue;
            log.info("Marking P2SH address as used: {}", (Object)address);
            this.currentAddresses.put((KeyChain.KeyPurpose)((Enum)entry.getKey()), this.freshAddress(entry.getKey()));
            return;
        }
    }

    private void maybeMarkCurrentKeyAsUsed(DeterministicKey key) {
        for (Map.Entry<KeyChain.KeyPurpose, DeterministicKey> entry : this.currentKeys.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(key)) continue;
            log.info("Marking key as used: {}", (Object)key);
            this.currentKeys.put((KeyChain.KeyPurpose)((Enum)entry.getKey()), this.freshKey(entry.getKey()));
            return;
        }
    }

    public boolean hasKey(ECKey key) {
        if (this.basic.hasKey(key)) {
            return true;
        }
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                if (!chain.hasKey(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public ECKey findKeyFromPubKey(byte[] pubKey) {
        ECKey result = this.basic.findKeyFromPubKey(pubKey);
        if (result != null) {
            return result;
        }
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                result = chain.findKeyFromPubKey(pubKey);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public void markPubKeyAsUsed(byte[] pubkey) {
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                DeterministicKey key = chain.markPubKeyAsUsed(pubkey);
                if (key == null) continue;
                this.maybeMarkCurrentKeyAsUsed(key);
                return;
            }
        }
    }

    public int numKeys() {
        int result = this.basic.numKeys();
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                result += chain.numKeys();
            }
        }
        return result;
    }

    public boolean removeImportedKey(ECKey key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((!(key instanceof DeterministicKey) ? 1 : 0) != 0);
        return this.basic.removeKey(key);
    }

    public final boolean isMarried() {
        return this.chains != null && !this.chains.isEmpty() && this.getActiveKeyChain().isMarried();
    }

    public void encrypt(KeyCrypter keyCrypter, KeyParameter aesKey) {
        Preconditions.checkNotNull((Object)keyCrypter);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkState((this.chains == null || !this.chains.isEmpty() || this.basic.numKeys() != 0 ? 1 : 0) != 0, (Object)"can't encrypt entirely empty wallet");
        BasicKeyChain newBasic = this.basic.toEncrypted(keyCrypter, aesKey);
        ArrayList<DeterministicKeyChain> newChains = new ArrayList<DeterministicKeyChain>();
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                newChains.add(chain.toEncrypted(keyCrypter, aesKey));
            }
        }
        this.keyCrypter = keyCrypter;
        this.basic = newBasic;
        this.chains.clear();
        this.chains.addAll(newChains);
    }

    public void decrypt(KeyParameter aesKey) {
        Preconditions.checkNotNull((Object)aesKey);
        BasicKeyChain newBasic = this.basic.toDecrypted(aesKey);
        ArrayList<DeterministicKeyChain> newChains = new ArrayList<DeterministicKeyChain>(this.chains.size());
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                newChains.add(chain.toDecrypted(aesKey));
            }
        }
        this.keyCrypter = null;
        this.basic = newBasic;
        this.chains.clear();
        this.chains.addAll(newChains);
    }

    public boolean isEncrypted() {
        return this.keyCrypter != null;
    }

    public boolean isWatching() {
        BasicKeyChain.State basicState = this.basic.isWatching();
        BasicKeyChain.State activeState = BasicKeyChain.State.EMPTY;
        if (this.chains != null && !this.chains.isEmpty()) {
            activeState = this.getActiveKeyChain().isWatching() ? BasicKeyChain.State.WATCHING : BasicKeyChain.State.REGULAR;
        }
        if (basicState == BasicKeyChain.State.EMPTY) {
            if (activeState == BasicKeyChain.State.EMPTY) {
                throw new IllegalStateException("Empty key chain group: cannot answer isWatching() query");
            }
            return activeState == BasicKeyChain.State.WATCHING;
        }
        if (activeState == BasicKeyChain.State.EMPTY) {
            return basicState == BasicKeyChain.State.WATCHING;
        }
        if (activeState != basicState) {
            throw new IllegalStateException("Mix of watching and non-watching keys in wallet");
        }
        return activeState == BasicKeyChain.State.WATCHING;
    }

    @Nullable
    public KeyCrypter getKeyCrypter() {
        return this.keyCrypter;
    }

    public List<ECKey> getImportedKeys() {
        return this.basic.getKeys();
    }

    public long getEarliestKeyCreationTime() {
        long time = this.basic.getEarliestKeyCreationTime();
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                time = Math.min(time, chain.getEarliestKeyCreationTime());
            }
        }
        return time;
    }

    public int getBloomFilterElementCount() {
        int result = this.basic.numBloomFilterEntries();
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                result += chain.numBloomFilterEntries();
            }
        }
        return result;
    }

    public BloomFilter getBloomFilter(int size, double falsePositiveRate, long nTweak) {
        BloomFilter filter = new BloomFilter(size, falsePositiveRate, nTweak);
        if (this.basic.numKeys() > 0) {
            filter.merge(this.basic.getFilter(size, falsePositiveRate, nTweak));
        }
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                filter.merge(chain.getFilter(size, falsePositiveRate, nTweak));
            }
        }
        return filter;
    }

    public boolean isRequiringUpdateAllBloomFilter() {
        throw new UnsupportedOperationException();
    }

    public void addEventListener(KeyChainEventListener listener) {
        this.addEventListener(listener, Threading.USER_THREAD);
    }

    public void addEventListener(KeyChainEventListener listener, Executor executor) {
        Preconditions.checkNotNull((Object)listener);
        Preconditions.checkNotNull((Object)executor);
        this.basic.addEventListener(listener, executor);
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                chain.addEventListener(listener, executor);
            }
        }
    }

    public boolean removeEventListener(KeyChainEventListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                chain.removeEventListener(listener);
            }
        }
        return this.basic.removeEventListener(listener);
    }

    public List<Protos.Key> serializeToProtobuf() {
        List<Object> result = this.basic != null ? this.basic.serializeToProtobuf() : Lists.newArrayList();
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                result.addAll(chain.serializeToProtobuf());
            }
        }
        return result;
    }

    static KeyChainGroup fromProtobufUnencrypted(NetworkParameters params, List<Protos.Key> keys) throws UnreadableWalletException {
        return KeyChainGroup.fromProtobufUnencrypted(params, keys, new DefaultKeyChainFactory());
    }

    public static KeyChainGroup fromProtobufUnencrypted(NetworkParameters params, List<Protos.Key> keys, KeyChainFactory factory) throws UnreadableWalletException {
        BasicKeyChain basicKeyChain = BasicKeyChain.fromProtobufUnencrypted(keys);
        List<DeterministicKeyChain> chains = DeterministicKeyChain.fromProtobuf(keys, null, factory);
        int lookaheadSize = -1;
        int lookaheadThreshold = -1;
        EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys = null;
        if (!chains.isEmpty()) {
            DeterministicKeyChain activeChain = chains.get(chains.size() - 1);
            lookaheadSize = activeChain.getLookaheadSize();
            lookaheadThreshold = activeChain.getLookaheadThreshold();
            currentKeys = KeyChainGroup.createCurrentKeysMap(chains);
        }
        KeyChainGroup.extractFollowingKeychains(chains);
        return new KeyChainGroup(params, basicKeyChain, chains, lookaheadSize, lookaheadThreshold, currentKeys, null);
    }

    static KeyChainGroup fromProtobufEncrypted(NetworkParameters params, List<Protos.Key> keys, KeyCrypter crypter) throws UnreadableWalletException {
        return KeyChainGroup.fromProtobufEncrypted(params, keys, crypter, new DefaultKeyChainFactory());
    }

    public static KeyChainGroup fromProtobufEncrypted(NetworkParameters params, List<Protos.Key> keys, KeyCrypter crypter, KeyChainFactory factory) throws UnreadableWalletException {
        Preconditions.checkNotNull((Object)crypter);
        BasicKeyChain basicKeyChain = BasicKeyChain.fromProtobufEncrypted(keys, crypter);
        List<DeterministicKeyChain> chains = DeterministicKeyChain.fromProtobuf(keys, crypter, factory);
        int lookaheadSize = -1;
        int lookaheadThreshold = -1;
        EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys = null;
        if (!chains.isEmpty()) {
            DeterministicKeyChain activeChain = chains.get(chains.size() - 1);
            lookaheadSize = activeChain.getLookaheadSize();
            lookaheadThreshold = activeChain.getLookaheadThreshold();
            currentKeys = KeyChainGroup.createCurrentKeysMap(chains);
        }
        KeyChainGroup.extractFollowingKeychains(chains);
        return new KeyChainGroup(params, basicKeyChain, chains, lookaheadSize, lookaheadThreshold, currentKeys, crypter);
    }

    public void upgradeToDeterministic(Script.ScriptType preferredScriptType, KeyChainGroupStructure structure, long keyRotationTimeSecs, @Nullable KeyParameter aesKey) throws DeterministicUpgradeRequiresPassword, AllRandomKeysRotating {
        Preconditions.checkState((boolean)this.isSupportsDeterministicChains(), (Object)"doesn't support deterministic chains");
        Preconditions.checkNotNull((Object)structure);
        Preconditions.checkArgument((keyRotationTimeSecs >= 0L ? 1 : 0) != 0);
        if (!this.isDeterministicUpgradeRequired(preferredScriptType, keyRotationTimeSecs)) {
            return;
        }
        if (this.basic.numKeys() > 0 && this.getActiveKeyChain(Script.ScriptType.P2PKH, keyRotationTimeSecs) == null) {
            ECKey keyToUse = this.basic.findOldestKeyAfter(keyRotationTimeSecs - 1L);
            if (keyToUse == null) {
                throw new AllRandomKeysRotating();
            }
            boolean keyWasEncrypted = keyToUse.isEncrypted();
            if (keyWasEncrypted) {
                if (aesKey == null) {
                    throw new DeterministicUpgradeRequiresPassword();
                }
                keyToUse = keyToUse.decrypt(aesKey);
            } else if (aesKey != null) {
                throw new IllegalStateException("AES Key was provided but wallet is not encrypted.");
            }
            log.info("Upgrading from basic keychain to P2PKH deterministic keychain. Using oldest non-rotating private key (address: {})", (Object)LegacyAddress.fromKey(this.params, keyToUse));
            byte[] entropy = (byte[])Preconditions.checkNotNull((Object)keyToUse.getSecretBytes());
            Preconditions.checkState((entropy.length >= 16 ? 1 : 0) != 0);
            entropy = Arrays.copyOfRange(entropy, 0, 16);
            Preconditions.checkState((entropy.length == 16 ? 1 : 0) != 0);
            DeterministicKeyChain chain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().entropy(entropy, keyToUse.getCreationTimeSeconds())).outputScriptType(Script.ScriptType.P2PKH)).accountPath(structure.accountPathFor(Script.ScriptType.P2PKH))).build();
            if (keyWasEncrypted) {
                chain = chain.toEncrypted((KeyCrypter)Preconditions.checkNotNull((Object)this.keyCrypter), aesKey);
            }
            this.addAndActivateHDChain(chain);
        }
        if (preferredScriptType == Script.ScriptType.P2WPKH && this.getActiveKeyChain(Script.ScriptType.P2WPKH, keyRotationTimeSecs) == null) {
            DeterministicSeed seed = this.getActiveKeyChain(Script.ScriptType.P2PKH, keyRotationTimeSecs).getSeed();
            boolean seedWasEncrypted = seed.isEncrypted();
            if (seedWasEncrypted) {
                if (aesKey == null) {
                    throw new DeterministicUpgradeRequiresPassword();
                }
                seed = seed.decrypt(this.keyCrypter, "", aesKey);
            }
            log.info("Upgrading from P2PKH to P2WPKH deterministic keychain. Using seed: {}", (Object)seed);
            DeterministicKeyChain chain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().seed(seed)).outputScriptType(Script.ScriptType.P2WPKH)).accountPath(structure.accountPathFor(Script.ScriptType.P2WPKH))).build();
            if (seedWasEncrypted) {
                chain = chain.toEncrypted((KeyCrypter)Preconditions.checkNotNull((Object)this.keyCrypter), aesKey);
            }
            this.addAndActivateHDChain(chain);
        }
    }

    public boolean isDeterministicUpgradeRequired(Script.ScriptType preferredScriptType, long keyRotationTimeSecs) {
        if (!this.isSupportsDeterministicChains()) {
            return false;
        }
        return this.getActiveKeyChain(preferredScriptType, keyRotationTimeSecs) == null;
    }

    private static EnumMap<KeyChain.KeyPurpose, DeterministicKey> createCurrentKeysMap(List<DeterministicKeyChain> chains) {
        DeterministicKeyChain activeChain = chains.get(chains.size() - 1);
        EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys = new EnumMap<KeyChain.KeyPurpose, DeterministicKey>(KeyChain.KeyPurpose.class);
        if (activeChain.getIssuedExternalKeys() > 0) {
            DeterministicKey currentExternalKey = activeChain.getKeyByPath((List<ChildNumber>)HDUtils.append(HDUtils.concat(activeChain.getAccountPath(), DeterministicKeyChain.EXTERNAL_SUBPATH), new ChildNumber(activeChain.getIssuedExternalKeys() - 1)));
            currentKeys.put(KeyChain.KeyPurpose.RECEIVE_FUNDS, currentExternalKey);
        }
        if (activeChain.getIssuedInternalKeys() > 0) {
            DeterministicKey currentInternalKey = activeChain.getKeyByPath((List<ChildNumber>)HDUtils.append(HDUtils.concat(activeChain.getAccountPath(), DeterministicKeyChain.INTERNAL_SUBPATH), new ChildNumber(activeChain.getIssuedInternalKeys() - 1)));
            currentKeys.put(KeyChain.KeyPurpose.CHANGE, currentInternalKey);
        }
        return currentKeys;
    }

    private static void extractFollowingKeychains(List<DeterministicKeyChain> chains) {
        ArrayList followingChains = Lists.newArrayList();
        Iterator<DeterministicKeyChain> it = chains.iterator();
        while (it.hasNext()) {
            DeterministicKeyChain chain = it.next();
            if (chain.isFollowing()) {
                followingChains.add(chain);
                it.remove();
                continue;
            }
            if (followingChains.isEmpty()) continue;
            if (!(chain instanceof MarriedKeyChain)) {
                throw new IllegalStateException();
            }
            ((MarriedKeyChain)chain).setFollowingKeyChains(followingChains);
            followingChains = Lists.newArrayList();
        }
    }

    public String toString(boolean includeLookahead, boolean includePrivateKeys, @Nullable KeyParameter aesKey) {
        StringBuilder builder = new StringBuilder();
        if (this.basic != null) {
            builder.append(this.basic.toString(includePrivateKeys, aesKey, this.params));
        }
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                builder.append(chain.toString(includeLookahead, includePrivateKeys, aesKey, this.params)).append('\n');
            }
        }
        return builder.toString();
    }

    public List<DeterministicKeyChain> getDeterministicKeyChains() {
        Preconditions.checkState((boolean)this.isSupportsDeterministicChains(), (Object)"doesn't support deterministic chains");
        return new ArrayList<DeterministicKeyChain>(this.chains);
    }

    public int getCombinedKeyLookaheadEpochs() {
        Preconditions.checkState((boolean)this.isSupportsDeterministicChains(), (Object)"doesn't support deterministic chains");
        int epoch = 0;
        for (DeterministicKeyChain chain : this.chains) {
            epoch += chain.getKeyLookaheadEpoch();
        }
        return epoch;
    }

    static {
        if (Utils.isAndroidRuntime()) {
            new LinuxSecureRandom();
        }
        log = LoggerFactory.getLogger(KeyChainGroup.class);
    }

    public static class Builder {
        private final NetworkParameters params;
        private final KeyChainGroupStructure structure;
        private final List<DeterministicKeyChain> chains = new LinkedList<DeterministicKeyChain>();
        private int lookaheadSize = -1;
        private int lookaheadThreshold = -1;

        private Builder(NetworkParameters params, KeyChainGroupStructure structure) {
            this.params = params;
            this.structure = structure;
        }

        public Builder fromRandom(Script.ScriptType outputScriptType) {
            DeterministicSeed seed = new DeterministicSeed(new SecureRandom(), 128, "");
            this.fromSeed(seed, outputScriptType);
            return this;
        }

        public Builder fromSeed(DeterministicSeed seed, Script.ScriptType outputScriptType) {
            if (outputScriptType == Script.ScriptType.P2PKH) {
                DeterministicKeyChain chain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().seed(seed)).outputScriptType(Script.ScriptType.P2PKH)).accountPath(this.structure.accountPathFor(Script.ScriptType.P2PKH))).build();
                this.chains.clear();
                this.chains.add(chain);
            } else if (outputScriptType == Script.ScriptType.P2WPKH) {
                DeterministicKeyChain fallbackChain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().seed(seed)).outputScriptType(Script.ScriptType.P2PKH)).accountPath(this.structure.accountPathFor(Script.ScriptType.P2PKH))).build();
                DeterministicKeyChain defaultChain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().seed(seed)).outputScriptType(Script.ScriptType.P2WPKH)).accountPath(this.structure.accountPathFor(Script.ScriptType.P2WPKH))).build();
                this.chains.clear();
                this.chains.add(fallbackChain);
                this.chains.add(defaultChain);
            } else {
                throw new IllegalArgumentException(outputScriptType.toString());
            }
            return this;
        }

        public Builder addChain(DeterministicKeyChain chain) {
            this.chains.add(chain);
            return this;
        }

        public Builder chains(List<DeterministicKeyChain> chains) {
            this.chains.clear();
            this.chains.addAll(chains);
            return this;
        }

        public Builder lookaheadSize(int lookaheadSize) {
            this.lookaheadSize = lookaheadSize;
            return this;
        }

        public Builder lookaheadThreshold(int lookaheadThreshold) {
            this.lookaheadThreshold = lookaheadThreshold;
            return this;
        }

        public KeyChainGroup build() {
            return new KeyChainGroup(this.params, null, this.chains, this.lookaheadSize, this.lookaheadThreshold, null, null);
        }
    }
}

