/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.ChildMessage;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.LegacyAddress;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBag;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VarInt;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.script.ScriptException;
import org.bitcoinj.script.ScriptPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionOutput
extends ChildMessage {
    private static final Logger log = LoggerFactory.getLogger(TransactionOutput.class);
    private long value;
    private byte[] scriptBytes;
    private Script scriptPubKey;
    private boolean availableForSpending;
    @Nullable
    private TransactionInput spentBy;
    private int scriptLen;

    public TransactionOutput(NetworkParameters params, @Nullable Transaction parent, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset);
        this.setParent(parent);
        this.availableForSpending = true;
    }

    public TransactionOutput(NetworkParameters params, @Nullable Transaction parent, byte[] payload, int offset, MessageSerializer serializer) throws ProtocolException {
        super(params, payload, offset, parent, serializer, Integer.MIN_VALUE);
        this.availableForSpending = true;
    }

    public TransactionOutput(NetworkParameters params, @Nullable Transaction parent, Coin value, Address to) {
        this(params, parent, value, ScriptBuilder.createOutputScript(to).getProgram());
    }

    public TransactionOutput(NetworkParameters params, @Nullable Transaction parent, Coin value, ECKey to) {
        this(params, parent, value, ScriptBuilder.createP2PKOutputScript(to).getProgram());
    }

    public TransactionOutput(NetworkParameters params, @Nullable Transaction parent, Coin value, byte[] scriptBytes) {
        super(params);
        Preconditions.checkArgument((value.signum() >= 0 || value.equals(Coin.NEGATIVE_SATOSHI) ? 1 : 0) != 0, (Object)"Negative values not allowed");
        Preconditions.checkArgument((!params.hasMaxMoney() || value.compareTo(params.getMaxMoney()) <= 0 ? 1 : 0) != 0, (Object)"Values larger than MAX_MONEY not allowed");
        this.value = value.value;
        this.scriptBytes = scriptBytes;
        this.setParent(parent);
        this.availableForSpending = true;
        this.length = 8 + VarInt.sizeOf(scriptBytes.length) + scriptBytes.length;
    }

    public Script getScriptPubKey() throws ScriptException {
        if (this.scriptPubKey == null) {
            this.scriptPubKey = new Script(this.scriptBytes);
        }
        return this.scriptPubKey;
    }

    @Nullable
    @Deprecated
    public LegacyAddress getAddressFromP2PKHScript(NetworkParameters params) throws ScriptException {
        if (ScriptPattern.isP2PKH(this.getScriptPubKey())) {
            return LegacyAddress.fromPubKeyHash(params, ScriptPattern.extractHashFromP2PKH(this.getScriptPubKey()));
        }
        return null;
    }

    @Nullable
    @Deprecated
    public LegacyAddress getAddressFromP2SH(NetworkParameters params) throws ScriptException {
        if (ScriptPattern.isP2SH(this.getScriptPubKey())) {
            return LegacyAddress.fromScriptHash(params, ScriptPattern.extractHashFromP2SH(this.getScriptPubKey()));
        }
        return null;
    }

    @Override
    protected void parse() throws ProtocolException {
        this.value = this.readInt64();
        this.scriptLen = (int)this.readVarInt();
        this.length = this.cursor - this.offset + this.scriptLen;
        this.scriptBytes = this.readBytes(this.scriptLen);
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        Preconditions.checkNotNull((Object)this.scriptBytes);
        Utils.int64ToByteStreamLE(this.value, stream);
        stream.write(new VarInt(this.scriptBytes.length).encode());
        stream.write(this.scriptBytes);
    }

    public Coin getValue() {
        try {
            return Coin.valueOf(this.value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void setValue(Coin value) {
        Preconditions.checkNotNull((Object)value);
        this.unCache();
        this.value = value.value;
    }

    public int getIndex() {
        List<TransactionOutput> outputs = this.getParentTransaction().getOutputs();
        for (int i = 0; i < outputs.size(); ++i) {
            if (outputs.get(i) != this) continue;
            return i;
        }
        throw new IllegalStateException("Output linked to wrong parent transaction?");
    }

    public boolean isDust() {
        if (ScriptPattern.isOpReturn(this.getScriptPubKey())) {
            return false;
        }
        return this.getValue().isLessThan(this.getMinNonDustValue());
    }

    public Coin getMinNonDustValue(Coin feePerKb) {
        long size = this.unsafeBitcoinSerialize().length + 148;
        return feePerKb.multiply(size).divide(1000L);
    }

    public Coin getMinNonDustValue() {
        return this.getMinNonDustValue(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE.multiply(3L));
    }

    public void markAsSpent(TransactionInput input) {
        Preconditions.checkState((boolean)this.availableForSpending);
        this.availableForSpending = false;
        this.spentBy = input;
        if (this.parent != null) {
            if (log.isDebugEnabled()) {
                log.debug("Marked {}:{} as spent by {}", new Object[]{this.getParentTransactionHash(), this.getIndex(), input});
            } else if (log.isDebugEnabled()) {
                log.debug("Marked floating output as spent by {}", (Object)input);
            }
        }
    }

    public void markAsUnspent() {
        if (this.parent != null) {
            if (log.isDebugEnabled()) {
                log.debug("Un-marked {}:{} as spent by {}", new Object[]{this.getParentTransactionHash(), this.getIndex(), this.spentBy});
            } else if (log.isDebugEnabled()) {
                log.debug("Un-marked floating output as spent by {}", (Object)this.spentBy);
            }
        }
        this.availableForSpending = true;
        this.spentBy = null;
    }

    public boolean isAvailableForSpending() {
        return this.availableForSpending;
    }

    public byte[] getScriptBytes() {
        return this.scriptBytes;
    }

    public boolean isMineOrWatched(TransactionBag transactionBag) {
        return this.isMine(transactionBag) || this.isWatched(transactionBag);
    }

    public boolean isWatched(TransactionBag transactionBag) {
        try {
            Script script = this.getScriptPubKey();
            return transactionBag.isWatchedScript(script);
        }
        catch (ScriptException e) {
            log.debug("Could not parse tx output script: {}", (Object)e.toString());
            return false;
        }
    }

    public boolean isMine(TransactionBag transactionBag) {
        try {
            Script script = this.getScriptPubKey();
            if (ScriptPattern.isP2PK(script)) {
                return transactionBag.isPubKeyMine(ScriptPattern.extractKeyFromP2PK(script));
            }
            if (ScriptPattern.isP2SH(script)) {
                return transactionBag.isPayToScriptHashMine(ScriptPattern.extractHashFromP2SH(script));
            }
            if (ScriptPattern.isP2PKH(script)) {
                return transactionBag.isPubKeyHashMine(ScriptPattern.extractHashFromP2PKH(script), Script.ScriptType.P2PKH);
            }
            if (ScriptPattern.isP2WPKH(script)) {
                return transactionBag.isPubKeyHashMine(ScriptPattern.extractHashFromP2WH(script), Script.ScriptType.P2WPKH);
            }
            return false;
        }
        catch (ScriptException e) {
            log.debug("Could not parse tx {} output script: {}", this.parent != null ? ((Transaction)this.parent).getTxId() : "(no parent)", (Object)e.toString());
            return false;
        }
    }

    public String toString() {
        try {
            Script script = this.getScriptPubKey();
            StringBuilder buf = new StringBuilder("TxOut of ");
            buf.append(Coin.valueOf(this.value).toFriendlyString());
            if (ScriptPattern.isP2PKH(script) || ScriptPattern.isP2WPKH(script) || ScriptPattern.isP2SH(script)) {
                buf.append(" to ").append(script.getToAddress(this.params));
            } else if (ScriptPattern.isP2PK(script)) {
                buf.append(" to pubkey ").append(Utils.HEX.encode(ScriptPattern.extractKeyFromP2PK(script)));
            } else if (ScriptPattern.isSentToMultisig(script)) {
                buf.append(" to multisig");
            } else {
                buf.append(" (unknown type)");
            }
            buf.append(" script:").append(script);
            return buf.toString();
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public TransactionInput getSpentBy() {
        return this.spentBy;
    }

    @Nullable
    public Transaction getParentTransaction() {
        return (Transaction)this.parent;
    }

    @Nullable
    public Sha256Hash getParentTransactionHash() {
        return this.parent == null ? null : ((Transaction)this.parent).getTxId();
    }

    public int getParentTransactionDepthInBlocks() {
        TransactionConfidence confidence;
        if (this.getParentTransaction() != null && (confidence = this.getParentTransaction().getConfidence()).getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING) {
            return confidence.getDepthInBlocks();
        }
        return -1;
    }

    public TransactionOutPoint getOutPointFor() {
        return new TransactionOutPoint(this.params, (long)this.getIndex(), this.getParentTransaction());
    }

    public TransactionOutput duplicateDetached() {
        return new TransactionOutput(this.params, null, Coin.valueOf(this.value), Arrays.copyOf(this.scriptBytes, this.scriptBytes.length));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionOutput other = (TransactionOutput)o;
        return this.value == other.value && (this.parent == null || this.parent == other.parent && this.getIndex() == other.getIndex()) && Arrays.equals(this.scriptBytes, other.scriptBytes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.parent, Arrays.hashCode(this.scriptBytes)});
    }
}

