/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;

public class ScalarTypeUUIDBinary
extends ScalarTypeBase<UUID> {
    protected ScalarTypeUUIDBinary() {
        super(UUID.class, false, -2);
    }

    @Override
    public int getLength() {
        return 16;
    }

    @Override
    public Object toJdbcType(Object value) {
        return ScalarTypeUUIDBinary.convertToBytes(value);
    }

    @Override
    public UUID toBeanType(Object value) {
        return ScalarTypeUUIDBinary.convertFromBytes((byte[])value);
    }

    @Override
    public String formatValue(UUID v) {
        return v.toString();
    }

    @Override
    public UUID parse(String value) {
        return UUID.fromString(value);
    }

    @Override
    public UUID parseDateTime(long dateTime) {
        throw new IllegalStateException("Never called");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    public static UUID convertFromBytes(byte[] bytes) {
        int usableBytes = Math.min(bytes.length, 16);
        byte[] barr = new byte[16];
        int i = 15;
        for (int j = usableBytes - 1; j >= 0; --j) {
            barr[i] = bytes[j];
            --i;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(barr);
        DataInputStream inputStream = new DataInputStream(bais);
        try {
            long msb = inputStream.readLong();
            long lsb = inputStream.readLong();
            return new UUID(msb, lsb);
        }
        catch (IOException e) {
            throw new RuntimeException("Not Expecting this", e);
        }
    }

    public static byte[] convertToBytes(Object value) {
        UUID uuid = (UUID)value;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(baos);
        try {
            outputStream.writeLong(uuid.getMostSignificantBits());
            outputStream.writeLong(uuid.getLeastSignificantBits());
        }
        catch (IOException e) {
            throw new RuntimeException("Not Expecting this", e);
        }
        return baos.toByteArray();
    }

    @Override
    public void bind(DataBind b, UUID value) throws SQLException {
        if (value == null) {
            b.setNull(-2);
        } else {
            b.setBytes(ScalarTypeUUIDBinary.convertToBytes(value));
        }
    }

    @Override
    public UUID read(DataReader dataReader) throws SQLException {
        byte[] bytes = dataReader.getBytes();
        if (bytes == null) {
            return null;
        }
        return ScalarTypeUUIDBinary.convertFromBytes(bytes);
    }

    @Override
    public Object readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return dataInput.readUTF();
    }

    @Override
    public void writeData(DataOutput dataOutput, Object v) throws IOException {
        String value = (String)v;
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeUTF(this.format(v));
        }
    }
}

