/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ModifyAwareMap;
import com.avaje.ebeaninternal.server.type.ModifyAwareOwner;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;

public class ScalarTypePostgresHstore
extends ScalarTypeBase<Map> {
    public static final String KEY = "hstore";
    public static final int HSTORE_TYPE = 4001;

    public ScalarTypePostgresHstore() {
        super(Map.class, false, 4001);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isDirty(Object value) {
        if (value instanceof ModifyAwareOwner) {
            return ((ModifyAwareOwner)value).isMarkedDirty();
        }
        return true;
    }

    @Override
    public Map read(DataReader dataReader) throws SQLException {
        Object value = dataReader.getObject();
        if (value == null) {
            return null;
        }
        if (!(value instanceof Map)) {
            throw new RuntimeException("Expecting Hstore to return as Map but got type " + value.getClass());
        }
        return new ModifyAwareMap((Map)value);
    }

    @Override
    public void bind(DataBind b, Map value) throws SQLException {
        b.setObject(value);
    }

    @Override
    public Object toJdbcType(Object value) {
        return value;
    }

    @Override
    public Map toBeanType(Object value) {
        return (Map)value;
    }

    @Override
    public String formatValue(Map v) {
        return null;
    }

    @Override
    public Map parse(String value) {
        return null;
    }

    @Override
    public Map parseDateTime(long dateTime) {
        throw new RuntimeException("Should never be called");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public Object readData(DataInput dataInput) throws IOException {
        return null;
    }

    @Override
    public void writeData(DataOutput dataOutput, Object v) throws IOException {
    }
}

