/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebeaninternal.api.Monitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;

public final class DefaultPersistenceContext
implements PersistenceContext {
    private final HashMap<String, ClassContext> typeCache = new HashMap();
    private final Monitor monitor = new Monitor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object id, Object bean) {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            this.getClassContext(bean.getClass()).put(id, bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putIfAbsent(Object id, Object bean) {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            return this.getClassContext(bean.getClass()).putIfAbsent(id, bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Class<?> beanType, Object id) {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            return this.getClassContext(beanType).get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistenceContext.WithOption getWithOption(Class<?> beanType, Object id) {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            return this.getClassContext(beanType).getWithOption(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(Class<?> beanType) {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            ClassContext classMap = this.typeCache.get(beanType.getName());
            return classMap == null ? 0 : classMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            this.typeCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(Class<?> beanType) {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            ClassContext classMap = this.typeCache.get(beanType.getName());
            if (classMap != null) {
                classMap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleted(Class<?> beanType, Object id) {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            ClassContext classMap = this.typeCache.get(beanType.getName());
            if (classMap != null && id != null) {
                classMap.deleted(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(Class<?> beanType, Object id) {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            ClassContext classMap = this.typeCache.get(beanType.getName());
            if (classMap != null && id != null) {
                classMap.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            return this.typeCache.toString();
        }
    }

    private ClassContext getClassContext(Class<?> beanType) {
        String clsName = this.getBeanBaseType(beanType).getName();
        ClassContext classMap = this.typeCache.get(clsName);
        if (classMap == null) {
            classMap = new ClassContext();
            this.typeCache.put(clsName, classMap);
        }
        return classMap;
    }

    private Class<?> getBeanBaseType(Class<?> beanType) {
        for (Class<?> parent = beanType.getSuperclass(); parent != null && parent.isAnnotationPresent(Entity.class); parent = parent.getSuperclass()) {
            beanType = parent;
        }
        return beanType;
    }

    private static class ClassContext {
        private final Map<Object, Object> map = new HashMap<Object, Object>();
        private Set<Object> deleteSet;

        private ClassContext() {
        }

        public String toString() {
            return "size:" + this.map.size();
        }

        private PersistenceContext.WithOption getWithOption(Object id) {
            if (this.deleteSet != null && this.deleteSet.contains(id)) {
                return PersistenceContext.WithOption.DELETED;
            }
            Object bean = this.map.get(id);
            return bean == null ? null : new PersistenceContext.WithOption(bean);
        }

        private Object get(Object id) {
            return this.map.get(id);
        }

        private Object putIfAbsent(Object id, Object bean) {
            Object existingValue = this.map.get(id);
            if (existingValue != null) {
                return existingValue;
            }
            this.map.put(id, bean);
            return null;
        }

        private void put(Object id, Object b) {
            this.map.put(id, b);
        }

        private int size() {
            return this.map.size();
        }

        private void clear() {
            this.map.clear();
        }

        private Object remove(Object id) {
            return this.map.remove(id);
        }

        private void deleted(Object id) {
            if (this.deleteSet == null) {
                this.deleteSet = new HashSet<Object>();
            }
            this.deleteSet.add(id);
            this.map.remove(id);
        }
    }
}

