/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.reflect;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.reflect.BeanReflect;
import com.avaje.ebeaninternal.server.reflect.BeanReflectGetter;
import com.avaje.ebeaninternal.server.reflect.BeanReflectSetter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import javax.persistence.PersistenceException;

public final class EnhanceBeanReflect
implements BeanReflect {
    private static final Object[] constuctorArgs = new Object[0];
    private final Constructor<?> constructor;

    public EnhanceBeanReflect(Class<?> clazz) {
        try {
            this.constructor = Modifier.isAbstract(clazz.getModifiers()) ? null : this.defaultConstructor(clazz);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private Constructor<?> defaultConstructor(Class<?> cls) {
        try {
            Class[] params = new Class[]{};
            return cls.getDeclaredConstructor(params);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Object createEntityBean() {
        try {
            return this.constructor.newInstance(constuctorArgs);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public BeanReflectGetter getGetter(String name, int position) {
        return new Getter(position);
    }

    @Override
    public BeanReflectSetter getSetter(String name, int position) {
        return new Setter(position);
    }

    static final class Setter
    implements BeanReflectSetter {
        private final int fieldIndex;

        Setter(int fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        @Override
        public void set(EntityBean bean, Object value) {
            bean._ebean_setField(this.fieldIndex, value);
        }

        @Override
        public void setIntercept(EntityBean bean, Object value) {
            bean._ebean_setFieldIntercept(this.fieldIndex, value);
        }
    }

    static final class Getter
    implements BeanReflectGetter {
        private final int fieldIndex;

        Getter(int fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        @Override
        public Object get(EntityBean bean) {
            return bean._ebean_getField(this.fieldIndex);
        }

        @Override
        public Object getIntercept(EntityBean bean) {
            return bean._ebean_getFieldIntercept(this.fieldIndex);
        }
    }
}

