/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssoc;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.DbReadContext;
import com.avaje.ebeaninternal.server.deploy.DbSqlContext;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.server.query.SqlJoinType;
import com.avaje.ebeaninternal.server.query.SqlTreeNode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SqlTreeNodeManyWhereJoin
implements SqlTreeNode {
    private final String parentPrefix;
    private final String prefix;
    private final BeanPropertyAssoc<?> nodeBeanProp;
    private final SqlTreeNode[] children;
    private final SqlJoinType manyJoinType;

    public SqlTreeNodeManyWhereJoin(String prefix, BeanPropertyAssoc<?> prop, SqlJoinType manyJoinType) {
        this.nodeBeanProp = prop;
        this.prefix = prefix;
        this.manyJoinType = manyJoinType;
        String[] split = SplitName.split(prefix);
        this.parentPrefix = split[0];
        ArrayList childrenList = new ArrayList(0);
        this.children = childrenList.toArray(new SqlTreeNode[childrenList.size()]);
    }

    @Override
    public void appendFrom(DbSqlContext ctx, SqlJoinType currentJoinType) {
        this.appendFromBaseTable(ctx, this.manyJoinType);
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].appendFrom(ctx, this.manyJoinType);
        }
    }

    public void appendFromBaseTable(DbSqlContext ctx, SqlJoinType joinType) {
        String alias = ctx.getTableAliasManyWhere(this.prefix);
        String parentAlias = ctx.getTableAliasManyWhere(this.parentPrefix);
        if (this.nodeBeanProp instanceof BeanPropertyAssocOne) {
            this.nodeBeanProp.addJoin(joinType, parentAlias, alias, ctx);
        } else {
            BeanPropertyAssocMany manyProp = (BeanPropertyAssocMany)this.nodeBeanProp;
            if (!manyProp.isManyToMany()) {
                manyProp.addJoin(joinType, parentAlias, alias, ctx);
            } else {
                String alias2 = alias + "z_";
                TableJoin manyToManyJoin = manyProp.getIntersectionTableJoin();
                manyToManyJoin.addJoin(joinType, parentAlias, alias2, ctx);
                manyProp.addJoin(joinType, alias2, alias, ctx);
            }
        }
    }

    @Override
    public void buildSelectExpressionChain(List<String> selectChain) {
    }

    @Override
    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
    }

    @Override
    public void appendWhere(DbSqlContext ctx) {
    }

    @Override
    public void load(DbReadContext ctx, EntityBean parentBean) throws SQLException {
    }
}

