/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist.dml;

import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;

public class GenerateDmlRequest {
    private static final String IS_NULL = " is null";
    private final boolean emptyStringAsNull;
    private final StringBuilder sb = new StringBuilder(100);
    private final EntityBeanIntercept ebi;
    private final boolean changesOnly;
    private StringBuilder insertBindBuffer;
    private String prefix;
    private String prefix2;
    private int insertMode;
    private int bindColumnCount;

    public GenerateDmlRequest(boolean emptyStringAsNull, EntityBeanIntercept ebi, boolean changesOnly) {
        this.emptyStringAsNull = emptyStringAsNull;
        this.ebi = ebi;
        this.changesOnly = changesOnly;
    }

    public GenerateDmlRequest(boolean emptyStringAsNull) {
        this(emptyStringAsNull, null, false);
    }

    public GenerateDmlRequest append(String s) {
        this.sb.append(s);
        return this;
    }

    public boolean isDbNull(Object v) {
        return v == null || this.emptyStringAsNull && v instanceof String && ((String)v).length() == 0;
    }

    public boolean isIncluded(BeanProperty prop) {
        if (this.ebi == null) {
            return true;
        }
        if (this.changesOnly) {
            return this.ebi.isDirtyProperty(prop.getPropertyIndex());
        }
        return this.ebi.isLoadedProperty(prop.getPropertyIndex());
    }

    public boolean isIncludedWhere(BeanProperty prop) {
        return this.ebi == null || this.ebi.isLoadedProperty(prop.getPropertyIndex());
    }

    public void appendColumnIsNull(String column) {
        this.appendColumn(column, IS_NULL);
    }

    public void appendColumn(String column) {
        this.appendColumn(column, "?");
    }

    public void appendColumn(String column, String bind) {
        this.appendColumn(column, "", bind);
    }

    public void appendColumn(String column, String expr, String bind) {
        ++this.bindColumnCount;
        this.sb.append(this.prefix);
        this.sb.append(column);
        if (this.insertMode > 0) {
            if (this.insertMode++ > 1) {
                this.insertBindBuffer.append(",");
            }
            this.insertBindBuffer.append(bind);
        } else {
            this.sb.append("=");
            this.sb.append(bind);
        }
        if (this.prefix2 != null) {
            this.prefix = this.prefix2;
            this.prefix2 = null;
        }
    }

    public int getBindColumnCount() {
        return this.bindColumnCount;
    }

    public String getInsertBindBuffer() {
        return this.insertBindBuffer.toString();
    }

    public String toString() {
        return this.sb.toString();
    }

    public void setWhereMode() {
        this.prefix = " and ";
        this.prefix2 = " and ";
    }

    public void setWhereIdMode() {
        this.prefix = "";
        this.prefix2 = " and ";
    }

    public void setInsertSetMode() {
        this.insertBindBuffer = new StringBuilder(100);
        this.insertMode = 1;
        this.prefix = "";
        this.prefix2 = ", ";
    }

    public void setUpdateSetMode() {
        this.prefix = "";
        this.prefix2 = ", ";
    }
}

