/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist.dml;

import com.avaje.ebean.annotation.ConcurrencyMode;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.persist.dml.DmlHandler;
import com.avaje.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import com.avaje.ebeaninternal.server.persist.dmlbind.Bindable;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableId;
import java.sql.SQLException;

public final class DeleteMeta {
    private final String sqlVersion;
    private final String sqlNone;
    private final BindableId id;
    private final Bindable version;
    private final String tableName;
    private final boolean emptyStringAsNull;

    public DeleteMeta(boolean emptyStringAsNull, BeanDescriptor<?> desc, BindableId id, Bindable version) {
        this.emptyStringAsNull = emptyStringAsNull;
        this.tableName = desc.getBaseTable();
        this.id = id;
        this.version = version;
        this.sqlNone = this.genSql(ConcurrencyMode.NONE);
        this.sqlVersion = this.genSql(ConcurrencyMode.VERSION);
    }

    public boolean isEmptyStringAsNull() {
        return this.emptyStringAsNull;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void bind(PersistRequestBean<?> persist, DmlHandler bind) throws SQLException {
        EntityBean bean = persist.getEntityBean();
        this.id.dmlBind(bind, bean);
        switch (persist.getConcurrencyMode()) {
            case VERSION: {
                this.version.dmlBind(bind, bean);
                break;
            }
        }
    }

    public String getSql(PersistRequestBean<?> request) throws SQLException {
        if (this.id.isEmpty()) {
            throw new IllegalStateException("Can not deleteById on " + request.getFullName() + " as no @Id property");
        }
        switch (request.determineConcurrencyMode()) {
            case NONE: {
                return this.sqlNone;
            }
            case VERSION: {
                return this.sqlVersion;
            }
        }
        throw new RuntimeException("Invalid mode " + (Object)((Object)request.determineConcurrencyMode()));
    }

    private String genSql(ConcurrencyMode conMode) {
        GenerateDmlRequest request = new GenerateDmlRequest(this.emptyStringAsNull);
        request.append("delete from ").append(this.tableName);
        request.append(" where ");
        request.setWhereIdMode();
        this.id.dmlAppend(request);
        if (ConcurrencyMode.VERSION.equals((Object)conMode)) {
            if (this.version == null) {
                return null;
            }
            this.version.dmlAppend(request);
        }
        return request.toString();
    }
}

