/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.loadcontext;

import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.BeanCollectionLoader;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebeaninternal.api.LoadManyBuffer;
import com.avaje.ebeaninternal.api.LoadManyContext;
import com.avaje.ebeaninternal.api.LoadManyRequest;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.loadcontext.DLoadBaseContext;
import com.avaje.ebeaninternal.server.loadcontext.DLoadContext;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.util.ArrayList;
import java.util.List;

public class DLoadManyContext
extends DLoadBaseContext
implements LoadManyContext {
    protected final BeanPropertyAssocMany<?> property;
    private List<LoadBuffer> bufferList;
    private LoadBuffer currentBuffer;

    public DLoadManyContext(DLoadContext parent, BeanPropertyAssocMany<?> property, String path, int defaultBatchSize, OrmQueryProperties queryProps) {
        super(parent, property.getBeanDescriptor(), path, defaultBatchSize, queryProps);
        this.property = property;
        this.bufferList = !this.queryFetch ? null : new ArrayList();
        this.currentBuffer = this.createBuffer(this.firstBatchSize);
    }

    private LoadBuffer createBuffer(int size) {
        LoadBuffer buffer = new LoadBuffer(this, size);
        if (this.bufferList != null) {
            this.bufferList.add(buffer);
        }
        return buffer;
    }

    public void configureQuery(SpiQuery<?> query) {
        if (this.parent.isReadOnly() != null) {
            query.setReadOnly(this.parent.isReadOnly());
        }
        query.setParentNode(this.objectGraphNode);
        if (this.queryProps != null) {
            this.queryProps.configureBeanQuery(query);
        }
        if (this.parent.isUseAutofetchManager()) {
            query.setAutofetch(true);
        }
    }

    public BeanPropertyAssocMany<?> getBeanProperty() {
        return this.property;
    }

    public BeanDescriptor<?> getBeanDescriptor() {
        return this.desc;
    }

    public String getName() {
        return this.parent.getEbeanServer().getName();
    }

    public void register(BeanCollection<?> bc) {
        if (this.currentBuffer.isFull()) {
            this.currentBuffer = this.createBuffer(this.secondaryBatchSize);
        }
        this.currentBuffer.add(bc);
        bc.setLoader(0, this.currentBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSecondaryQuery(OrmQueryRequest<?> parentRequest, int requestedBatchSize, boolean all) {
        if (!this.queryFetch) {
            throw new IllegalStateException("Not expecting loadSecondaryQuery() to be called?");
        }
        DLoadManyContext dLoadManyContext = this;
        synchronized (dLoadManyContext) {
            if (this.bufferList != null) {
                for (LoadBuffer loadBuffer : this.bufferList) {
                    if (loadBuffer.list.isEmpty()) continue;
                    LoadManyRequest req = new LoadManyRequest(loadBuffer, parentRequest, requestedBatchSize, false, false, false);
                    this.parent.getEbeanServer().loadMany(req);
                    if (this.queryProps.isQueryFetchAll()) continue;
                    break;
                }
                this.bufferList = null;
            }
        }
    }

    public static class LoadBuffer
    implements BeanCollectionLoader,
    LoadManyBuffer {
        private final PersistenceContext persistenceContext;
        private final DLoadManyContext context;
        private final int batchSize;
        private final List<BeanCollection<?>> list;

        public LoadBuffer(DLoadManyContext context, int batchSize) {
            this.context = context;
            this.persistenceContext = context.getPersistenceContext();
            this.batchSize = batchSize;
            this.list = new ArrayList(batchSize);
        }

        public boolean isFull() {
            return this.batchSize == this.list.size();
        }

        public void add(BeanCollection<?> bc) {
            this.list.add(bc);
        }

        @Override
        public List<BeanCollection<?>> getBatch() {
            return this.list;
        }

        @Override
        public BeanPropertyAssocMany<?> getBeanProperty() {
            return this.context.property;
        }

        @Override
        public ObjectGraphNode getObjectGraphNode() {
            return this.context.objectGraphNode;
        }

        @Override
        public void configureQuery(SpiQuery<?> query) {
            this.context.configureQuery(query);
        }

        @Override
        public String getName() {
            return this.context.serverName;
        }

        @Override
        public BeanDescriptor<?> getBeanDescriptor() {
            return this.context.desc;
        }

        @Override
        public PersistenceContext getPersistenceContext() {
            return this.persistenceContext;
        }

        @Override
        public String getFullPath() {
            return this.context.fullPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loadMany(BeanCollection<?> bc, boolean onlyIds) {
            LoadBuffer loadBuffer = this;
            synchronized (loadBuffer) {
                Object parentId;
                EntityBean ownerBean;
                BeanDescriptor<?> parentDesc;
                boolean useCache;
                boolean bl = useCache = this.context.hitCache && !onlyIds;
                if (useCache && (parentDesc = this.context.desc.getBeanDescriptor((ownerBean = bc.getOwnerBean()).getClass())).cacheManyPropLoad(this.context.property, bc, parentId = parentDesc.getId(ownerBean), this.context.parent.isReadOnly())) {
                    this.list.remove(bc);
                    return;
                }
                LoadManyRequest req = new LoadManyRequest(this, this.batchSize, true, onlyIds, useCache);
                this.context.parent.getEbeanServer().loadMany(req);
            }
        }
    }
}

