/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib.sql;

import com.avaje.ebean.config.DataSourceConfig;
import com.avaje.ebeaninternal.api.ClassUtil;
import com.avaje.ebeaninternal.server.lib.sql.DataSourceAlert;
import com.avaje.ebeaninternal.server.lib.sql.DataSourceException;
import com.avaje.ebeaninternal.server.lib.sql.DataSourcePoolListener;
import com.avaje.ebeaninternal.server.lib.sql.DataSourcePoolStatistics;
import com.avaje.ebeaninternal.server.lib.sql.PooledConnection;
import com.avaje.ebeaninternal.server.lib.sql.PooledConnectionQueue;
import com.avaje.ebeaninternal.server.lib.sql.TransactionIsolation;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourcePool
implements DataSource {
    private static final Logger logger = LoggerFactory.getLogger(DataSourcePool.class);
    private final String name;
    private final DataSourceAlert notify;
    private final DataSourcePoolListener poolListener;
    private final Properties connectionProps;
    private final String databaseUrl;
    private final String databaseDriver;
    private final String heartbeatsql;
    private final int heartbeatFreqSecs;
    private final int heartbeatTimeoutSeconds;
    private final long trimPoolFreqMillis;
    private final int transactionIsolation;
    private final boolean autoCommit;
    private final int maxInactiveMillis;
    private final long maxAgeMillis;
    private boolean captureStackTrace;
    private int maxStackTraceSize;
    private boolean dataSourceDownAlertSent;
    private long lastTrimTime;
    private boolean dataSourceUp = true;
    private boolean inWarningMode;
    private int minConnections;
    private int maxConnections;
    private int warningSize;
    private final int waitTimeoutMillis;
    private int pstmtCacheSize;
    private final PooledConnectionQueue queue;
    private long leakTimeMinutes;
    private final Runnable heartbeatRunnable = new HeartBeatRunnable();

    public DataSourcePool(DataSourceAlert notify, String name, DataSourceConfig params) {
        this.notify = notify;
        this.name = name;
        this.poolListener = this.createPoolListener(params.getPoolListener());
        this.autoCommit = params.isAutoCommit();
        this.transactionIsolation = params.getIsolationLevel();
        this.maxInactiveMillis = 1000 * params.getMaxInactiveTimeSecs();
        this.maxAgeMillis = 60000 * params.getMaxAgeMinutes();
        this.leakTimeMinutes = params.getLeakTimeMinutes();
        this.captureStackTrace = params.isCaptureStackTrace();
        this.maxStackTraceSize = params.getMaxStackTraceSize();
        this.databaseDriver = params.getDriver();
        this.databaseUrl = params.getUrl();
        this.pstmtCacheSize = params.getPstmtCacheSize();
        this.minConnections = params.getMinConnections();
        this.maxConnections = params.getMaxConnections();
        this.waitTimeoutMillis = params.getWaitTimeoutMillis();
        this.heartbeatsql = params.getHeartbeatSql();
        this.heartbeatFreqSecs = params.getHeartbeatFreqSecs();
        this.heartbeatTimeoutSeconds = params.getHeartbeatTimeoutSeconds();
        this.trimPoolFreqMillis = 1000 * params.getTrimPoolFreqSecs();
        this.queue = new PooledConnectionQueue(this);
        String un = params.getUsername();
        String pw = params.getPassword();
        if (un == null) {
            throw new RuntimeException("DataSource user is null?");
        }
        if (pw == null) {
            throw new RuntimeException("DataSource password is null?");
        }
        this.connectionProps = new Properties();
        this.connectionProps.setProperty("user", un);
        this.connectionProps.setProperty("password", pw);
        Map<String, String> customProperties = params.getCustomProperties();
        if (customProperties != null) {
            Set<Map.Entry<String, String>> entrySet = customProperties.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                this.connectionProps.setProperty(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.initialise();
        }
        catch (SQLException ex) {
            throw new DataSourceException(ex);
        }
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("We do not support java.util.logging");
    }

    private DataSourcePoolListener createPoolListener(String cn) {
        if (cn == null) {
            return null;
        }
        try {
            return (DataSourcePoolListener)ClassUtil.newInstance(cn, this.getClass());
        }
        catch (Exception e) {
            throw new DataSourceException(e);
        }
    }

    private void initialise() throws SQLException {
        try {
            ClassUtil.forName(this.databaseDriver, this.getClass());
        }
        catch (Throwable e) {
            throw new PersistenceException("Problem loading Database Driver [" + this.databaseDriver + "]: " + e.getMessage(), e);
        }
        String transIsolation = TransactionIsolation.getLevelDescription(this.transactionIsolation);
        StringBuilder sb = new StringBuilder();
        sb.append("DataSourcePool [").append(this.name);
        sb.append("] autoCommit[").append(this.autoCommit);
        sb.append("] transIsolation[").append(transIsolation);
        sb.append("] min[").append(this.minConnections);
        sb.append("] max[").append(this.maxConnections).append("]");
        logger.info(sb.toString());
        this.queue.ensureMinimumConnections();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public String getName() {
        return this.name;
    }

    public int getMaxStackTraceSize() {
        return this.maxStackTraceSize;
    }

    public boolean isDataSourceUp() {
        return this.dataSourceUp;
    }

    protected void notifyWarning(String msg) {
        if (!this.inWarningMode) {
            this.inWarningMode = true;
            logger.warn(msg);
            if (this.notify != null) {
                String subject = "DataSourcePool [" + this.name + "] warning";
                this.notify.dataSourceWarning(subject, msg);
            }
        }
    }

    private void notifyDataSourceIsDown(SQLException ex) {
        if (!this.dataSourceDownAlertSent) {
            logger.error("FATAL: DataSourcePool [" + this.name + "] is down or has network error!!!", (Throwable)ex);
            if (this.notify != null) {
                this.notify.dataSourceDown(this.name);
            }
            this.dataSourceDownAlertSent = true;
        }
        if (this.dataSourceUp) {
            this.reset();
        }
        this.dataSourceUp = false;
    }

    private void notifyDataSourceIsUp() {
        if (this.dataSourceDownAlertSent) {
            logger.error("RESOLVED FATAL: DataSourcePool [" + this.name + "] is back up!");
            if (this.notify != null) {
                this.notify.dataSourceUp(this.name);
            }
            this.dataSourceDownAlertSent = false;
        } else if (!this.dataSourceUp) {
            logger.info("DataSourcePool [" + this.name + "] is back up!");
        }
        if (!this.dataSourceUp) {
            this.dataSourceUp = true;
            this.reset();
        }
    }

    public int getHeartbeatFreqSecs() {
        return this.heartbeatFreqSecs;
    }

    public Runnable getHeartbeatRunnable() {
        return this.heartbeatRunnable;
    }

    private void trimIdleConnections() {
        if (System.currentTimeMillis() > this.lastTrimTime + this.trimPoolFreqMillis) {
            try {
                this.queue.trim(this.maxInactiveMillis, this.maxAgeMillis);
                this.lastTrimTime = System.currentTimeMillis();
            }
            catch (Exception e) {
                logger.error("Error trying to trim idle connections", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDataSource() {
        this.trimIdleConnections();
        Connection conn = null;
        try {
            conn = this.getConnection();
            if (this.testConnection(conn)) {
                this.notifyDataSourceIsUp();
            } else {
                this.notifyDataSourceIsDown(null);
            }
        }
        catch (SQLException ex) {
            this.notifyDataSourceIsDown(ex);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                logger.warn("Can't close connection in checkDataSource!");
            }
        }
    }

    public Connection createUnpooledConnection() throws SQLException {
        try {
            Connection conn = DriverManager.getConnection(this.databaseUrl, this.connectionProps);
            conn.setAutoCommit(this.autoCommit);
            conn.setTransactionIsolation(this.transactionIsolation);
            return conn;
        }
        catch (SQLException ex) {
            this.notifyDataSourceIsDown(null);
            throw ex;
        }
    }

    public void setMaxSize(int max) {
        this.queue.setMaxSize(max);
        this.maxConnections = max;
    }

    public int getMaxSize() {
        return this.maxConnections;
    }

    public void setMinSize(int min) {
        this.queue.setMinSize(min);
        this.minConnections = min;
    }

    public int getMinSize() {
        return this.minConnections;
    }

    public void setWarningSize(int warningSize) {
        this.queue.setWarningSize(warningSize);
        this.warningSize = warningSize;
    }

    public int getWarningSize() {
        return this.warningSize;
    }

    public int getWaitTimeoutMillis() {
        return this.waitTimeoutMillis;
    }

    public int getMaxInactiveMillis() {
        return this.maxInactiveMillis;
    }

    public long getMaxAgeMillis() {
        return this.maxAgeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testConnection(Connection conn) throws SQLException {
        if (this.heartbeatsql == null) {
            return conn.isValid(this.heartbeatTimeoutSeconds);
        }
        Statement stmt = null;
        ResultSet rset = null;
        try {
            stmt = conn.createStatement();
            if (this.heartbeatTimeoutSeconds > 0) {
                stmt.setQueryTimeout(this.heartbeatTimeoutSeconds);
            }
            rset = stmt.executeQuery(this.heartbeatsql);
            conn.commit();
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (SQLException e) {
                logger.error(null, (Throwable)e);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                logger.error(null, (Throwable)e);
            }
        }
    }

    protected boolean validateConnection(PooledConnection conn) {
        try {
            return this.testConnection(conn);
        }
        catch (Exception e) {
            logger.warn("heartbeatsql test failed on connection[" + conn.getName() + "]");
            return false;
        }
    }

    protected void returnConnection(PooledConnection pooledConnection) {
        this.returnTheConnection(pooledConnection, false);
    }

    protected void returnConnectionForceClose(PooledConnection pooledConnection) {
        this.returnTheConnection(pooledConnection, true);
    }

    private void returnTheConnection(PooledConnection pooledConnection, boolean forceClose) {
        if (this.poolListener != null && !forceClose) {
            this.poolListener.onBeforeReturnConnection(pooledConnection);
        }
        this.queue.returnPooledConnection(pooledConnection, forceClose);
        if (forceClose) {
            this.checkDataSource();
        }
    }

    protected void reportClosingConnection(PooledConnection pooledConnection) {
        this.queue.reportClosingConnection(pooledConnection);
    }

    public String getBusyConnectionInformation() {
        return this.queue.getBusyConnectionInformation();
    }

    public void dumpBusyConnectionInformation() {
        this.queue.dumpBusyConnectionInformation();
    }

    public void closeBusyConnections(long leakTimeMinutes) {
        this.queue.closeBusyConnections(leakTimeMinutes);
    }

    protected PooledConnection createConnectionForQueue(int connId) throws SQLException {
        try {
            Connection c = this.createUnpooledConnection();
            PooledConnection pc = new PooledConnection(this, connId, c);
            pc.resetForUse();
            if (!this.dataSourceUp) {
                this.notifyDataSourceIsUp();
            }
            return pc;
        }
        catch (SQLException ex) {
            this.notifyDataSourceIsDown(ex);
            throw ex;
        }
    }

    public void reset() {
        this.queue.reset(this.leakTimeMinutes);
        this.inWarningMode = false;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getPooledConnection();
    }

    public PooledConnection getPooledConnection() throws SQLException {
        PooledConnection c = this.queue.getPooledConnection();
        if (this.captureStackTrace) {
            c.setStackTrace(Thread.currentThread().getStackTrace());
        }
        if (this.poolListener != null) {
            this.poolListener.onAfterBorrowConnection(c);
        }
        return c;
    }

    public void testAlert() {
        String subject = "Test DataSourcePool [" + this.name + "]";
        String msg = "Just testing if alert message is sent successfully.";
        if (this.notify != null) {
            this.notify.dataSourceWarning(subject, msg);
        }
    }

    public void shutdown(boolean deregisterDriver) {
        this.queue.shutdown();
        if (deregisterDriver) {
            this.deregisterDriver();
        }
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public boolean isCaptureStackTrace() {
        return this.captureStackTrace;
    }

    public void setCaptureStackTrace(boolean captureStackTrace) {
        this.captureStackTrace = captureStackTrace;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter writer) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public void setLeakTimeMinutes(long leakTimeMinutes) {
        this.leakTimeMinutes = leakTimeMinutes;
    }

    public long getLeakTimeMinutes() {
        return this.leakTimeMinutes;
    }

    public int getPstmtCacheSize() {
        return this.pstmtCacheSize;
    }

    public void setPstmtCacheSize(int pstmtCacheSize) {
        this.pstmtCacheSize = pstmtCacheSize;
    }

    public Status getStatus(boolean reset) {
        return this.queue.getStatus(reset);
    }

    public DataSourcePoolStatistics getStatistics(boolean reset) {
        return this.queue.getStatistics(reset);
    }

    public void deregisterDriver() {
        try {
            logger.debug("Deregistered the JDBC driver " + this.databaseDriver);
            DriverManager.deregisterDriver(DriverManager.getDriver(this.databaseUrl));
        }
        catch (SQLException e) {
            logger.warn("Error trying to deregister the JDBC driver " + this.databaseDriver, (Throwable)e);
        }
    }

    public static class Status {
        private final String name;
        private final int minSize;
        private final int maxSize;
        private final int free;
        private final int busy;
        private final int waiting;
        private final int highWaterMark;
        private final int waitCount;
        private final int hitCount;

        protected Status(String name, int minSize, int maxSize, int free, int busy, int waiting, int highWaterMark, int waitCount, int hitCount) {
            this.name = name;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.free = free;
            this.busy = busy;
            this.waiting = waiting;
            this.highWaterMark = highWaterMark;
            this.waitCount = waitCount;
            this.hitCount = hitCount;
        }

        public String toString() {
            return "min[" + this.minSize + "] max[" + this.maxSize + "] free[" + this.free + "] busy[" + this.busy + "] waiting[" + this.waiting + "] highWaterMark[" + this.highWaterMark + "] waitCount[" + this.waitCount + "] hitCount[" + this.hitCount + "]";
        }

        public String getName() {
            return this.name;
        }

        public int getMinSize() {
            return this.minSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public int getFree() {
            return this.free;
        }

        public int getBusy() {
            return this.busy;
        }

        public int getWaiting() {
            return this.waiting;
        }

        public int getHighWaterMark() {
            return this.highWaterMark;
        }

        public int getWaitCount() {
            return this.waitCount;
        }

        public int getHitCount() {
            return this.hitCount;
        }
    }

    class HeartBeatRunnable
    implements Runnable {
        HeartBeatRunnable() {
        }

        @Override
        public void run() {
            DataSourcePool.this.checkDataSource();
        }
    }
}

