/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib;

import com.avaje.ebeaninternal.server.lib.DaemonThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DaemonThreadPool
extends ThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DaemonThreadPool.class);
    private final String namePrefix;
    private final int shutdownWaitSeconds;

    public DaemonThreadPool(int coreSize, long keepAliveSecs, int shutdownWaitSeconds, String namePrefix) {
        super(coreSize, coreSize, keepAliveSecs, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory(namePrefix));
        this.allowCoreThreadTimeOut(true);
        this.shutdownWaitSeconds = shutdownWaitSeconds;
        this.namePrefix = namePrefix;
    }

    public void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        DaemonThreadPool daemonThreadPool = this;
        synchronized (daemonThreadPool) {
            if (super.isShutdown()) {
                logger.debug("DaemonThreadPool[" + this.namePrefix + "] already shut down");
                return;
            }
            try {
                logger.debug("DaemonThreadPool[" + this.namePrefix + "] shutting down...");
                super.shutdown();
                if (!super.awaitTermination(this.shutdownWaitSeconds, TimeUnit.SECONDS)) {
                    logger.info("DaemonThreadPool[" + this.namePrefix + "] shut down timeout exceeded. Terminating running threads.");
                    super.shutdownNow();
                }
            }
            catch (Exception e) {
                logger.error("Error during shutdown of DaemonThreadPool[" + this.namePrefix + "]", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            DaemonThreadPool.this.shutdown();
        }
    }
}

