/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.el.ElPropertyDeploy;

class BetweenPropertyExpression
implements SpiExpression {
    private static final long serialVersionUID = 2078918165221454910L;
    private static final String BETWEEN = " between ";
    private final String lowProperty;
    private final String highProperty;
    private final Object value;

    BetweenPropertyExpression(String lowProperty, String highProperty, Object value) {
        this.lowProperty = lowProperty;
        this.highProperty = highProperty;
        this.value = value;
    }

    protected String name(String propName) {
        return propName;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        ElPropertyDeploy elProp = desc.getElPropertyDeploy(this.name(this.lowProperty));
        if (elProp != null && elProp.containsMany()) {
            manyWhereJoin.add(elProp);
        }
        if ((elProp = desc.getElPropertyDeploy(this.name(this.highProperty))) != null && elProp.containsMany()) {
            manyWhereJoin.add(elProp);
        }
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        request.addBindValue(this.value);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.append(" ? ").append(BETWEEN).append(this.name(this.lowProperty)).append(" and ").append(this.name(this.highProperty));
    }

    @Override
    public void queryAutoFetchHash(HashQueryPlanBuilder builder) {
        builder.add(BetweenPropertyExpression.class).add(this.lowProperty).add(this.highProperty);
        builder.bind(1);
    }

    @Override
    public void queryPlanHash(BeanQueryRequest<?> request, HashQueryPlanBuilder builder) {
        this.queryAutoFetchHash(builder);
    }

    @Override
    public int queryBindHash() {
        return this.value.hashCode();
    }
}

