/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.event.BeanPersistAdapter;
import com.avaje.ebean.event.BeanPersistRequest;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.lang.reflect.Method;
import java.util.Set;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanLifecycleAdapterFactory {
    private static final Logger logger = LoggerFactory.getLogger(BeanLifecycleAdapterFactory.class);

    public void addLifecycleMethods(DeployBeanDescriptor<?> deployDesc) {
        Method[] methods = deployDesc.getBeanType().getMethods();
        MethodHolder methodHolder = new MethodHolder();
        for (Method m : methods) {
            methodHolder.checkMethod(m);
        }
        if (methodHolder.hasListener()) {
            deployDesc.addPersistController(new Adapter(methodHolder));
        }
    }

    private static class Adapter
    extends BeanPersistAdapter {
        private final MethodHolder methodHolder;

        private Adapter(MethodHolder methodHolder) {
            this.methodHolder = methodHolder;
        }

        @Override
        public boolean isRegisterFor(Class<?> cls) {
            return false;
        }

        private void invoke(Method method, Object bean) {
            try {
                method.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                logger.error("Error invoking lifecycle adapter", (Throwable)e);
            }
        }

        private void invoke(Method method, BeanPersistRequest<?> request) {
            this.invoke(method, request.getBean());
        }

        @Override
        public boolean preDelete(BeanPersistRequest<?> request) {
            if (this.methodHolder.preDelete != null) {
                this.invoke(this.methodHolder.preDelete, request);
            }
            return true;
        }

        @Override
        public boolean preInsert(BeanPersistRequest<?> request) {
            if (this.methodHolder.preInsert != null) {
                this.invoke(this.methodHolder.preInsert, request);
            }
            return true;
        }

        @Override
        public boolean preUpdate(BeanPersistRequest<?> request) {
            if (this.methodHolder.preUpdate != null) {
                this.invoke(this.methodHolder.preUpdate, request);
            }
            return true;
        }

        @Override
        public void postDelete(BeanPersistRequest<?> request) {
            if (this.methodHolder.postDelete != null) {
                this.invoke(this.methodHolder.postDelete, request);
            }
        }

        @Override
        public void postInsert(BeanPersistRequest<?> request) {
            if (this.methodHolder.postInsert != null) {
                this.invoke(this.methodHolder.postInsert, request);
            }
        }

        @Override
        public void postUpdate(BeanPersistRequest<?> request) {
            if (this.methodHolder.postUpdate != null) {
                this.invoke(this.methodHolder.postUpdate, request);
            }
        }

        @Override
        public void postLoad(Object bean, Set<String> includedProperties) {
            if (this.methodHolder.postLoad != null) {
                this.invoke(this.methodHolder.postLoad, bean);
            }
        }
    }

    private static class MethodHolder {
        private boolean hasListener;
        private Method preInsert;
        private Method postInsert;
        private Method preUpdate;
        private Method postUpdate;
        private Method preDelete;
        private Method postDelete;
        private Method postLoad;

        private MethodHolder() {
        }

        private boolean hasListener() {
            return this.hasListener;
        }

        private void checkMethod(Method method) {
            if (method.isAnnotationPresent(PrePersist.class)) {
                this.preInsert = method;
                this.hasListener = true;
            }
            if (method.isAnnotationPresent(PostPersist.class)) {
                this.postInsert = method;
                this.hasListener = true;
            }
            if (method.isAnnotationPresent(PreUpdate.class)) {
                this.preUpdate = method;
                this.hasListener = true;
            }
            if (method.isAnnotationPresent(PostUpdate.class)) {
                this.postUpdate = method;
                this.hasListener = true;
            }
            if (method.isAnnotationPresent(PreRemove.class)) {
                this.preDelete = method;
                this.hasListener = true;
            }
            if (method.isAnnotationPresent(PostRemove.class)) {
                this.postDelete = method;
                this.hasListener = true;
            }
            if (method.isAnnotationPresent(PostLoad.class)) {
                this.postLoad = method;
                this.hasListener = true;
            }
        }
    }
}

