/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.QueryIterator;
import com.avaje.ebean.QueryResultVisitor;
import com.avaje.ebean.RawSql;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.event.BeanFinder;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.BeanIdList;
import com.avaje.ebeaninternal.api.HashQuery;
import com.avaje.ebeaninternal.api.HashQueryPlan;
import com.avaje.ebeaninternal.api.LoadContext;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.BeanRequest;
import com.avaje.ebeaninternal.server.core.OrmQueryEngine;
import com.avaje.ebeaninternal.server.core.SpiOrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.DeployParser;
import com.avaje.ebeaninternal.server.deploy.DeployPropertyParserMap;
import com.avaje.ebeaninternal.server.loadcontext.DLoadContext;
import com.avaje.ebeaninternal.server.query.CQueryPlan;
import com.avaje.ebeaninternal.server.query.CancelableQuery;
import com.avaje.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;

public final class OrmQueryRequest<T>
extends BeanRequest
implements BeanQueryRequest<T>,
SpiOrmQueryRequest<T> {
    private final BeanDescriptor<T> beanDescriptor;
    private final OrmQueryEngine queryEngine;
    private final SpiQuery<T> query;
    private final BeanFinder<T> finder;
    private final Boolean readOnly;
    private final RawSql rawSql;
    private LoadContext loadContext;
    private PersistenceContext persistenceContext;
    private HashQuery cacheKey;
    private HashQueryPlan queryPlanHash;

    public OrmQueryRequest(SpiEbeanServer server, OrmQueryEngine queryEngine, SpiQuery<T> query, BeanDescriptor<T> desc, SpiTransaction t) {
        super(server, t);
        this.beanDescriptor = desc;
        this.rawSql = query.getRawSql();
        this.finder = this.beanDescriptor.getBeanFinder();
        this.queryEngine = queryEngine;
        this.query = query;
        this.readOnly = query.isReadOnly();
    }

    public void executeSecondaryQueries(int defaultQueryBatch) {
        this.loadContext.executeSecondaryQueries(this, defaultQueryBatch);
    }

    public int getSecondaryQueriesMinBatchSize(int defaultQueryBatch) {
        return this.loadContext.getSecondaryQueriesMinBatchSize(this, defaultQueryBatch);
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public BeanDescriptor<T> getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public LoadContext getGraphContext() {
        return this.loadContext;
    }

    public void calculateQueryPlanHash() {
        this.queryPlanHash = this.query.queryPlanHash(this);
    }

    public boolean isRawSql() {
        return this.rawSql != null;
    }

    public DeployParser createDeployParser() {
        if (this.rawSql != null) {
            return new DeployPropertyParserMap(this.rawSql.getColumnMapping().getMapping());
        }
        return this.beanDescriptor.createDeployPropertyParser();
    }

    public boolean isSqlSelect() {
        return this.query.isSqlSelect() && this.query.getRawSql() == null;
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void initTransIfRequired() {
        if (this.transaction == null) {
            this.transaction = this.ebeanServer.getCurrentServerTransaction();
            if (this.transaction == null) {
                this.transaction = this.ebeanServer.createQueryTransaction();
                this.createdTransaction = true;
            }
        }
        this.persistenceContext = this.getPersistenceContext(this.query, this.transaction);
        this.loadContext = new DLoadContext(this);
        this.loadContext.registerSecondaryQueries(this.query);
    }

    public void flushPersistenceContextOnIterate() {
        this.persistenceContext = new DefaultPersistenceContext();
        this.loadContext.setPersistenceContext(this.persistenceContext);
    }

    private PersistenceContext getPersistenceContext(SpiQuery<?> query, SpiTransaction t) {
        PersistenceContext ctx = query.getPersistenceContext();
        if (ctx == null) {
            ctx = t.getPersistenceContext();
        }
        return ctx;
    }

    @Override
    public void endTransIfRequired() {
        if (this.createdTransaction) {
            this.transaction.endQueryOnly();
        }
    }

    public boolean isFindById() {
        return this.query.getType() == SpiQuery.Type.BEAN;
    }

    @Override
    public Object findId() {
        return this.queryEngine.findId(this);
    }

    @Override
    public int findRowCount() {
        return this.queryEngine.findRowCount(this);
    }

    @Override
    public List<Object> findIds() {
        BeanIdList idList = this.queryEngine.findIds(this);
        return idList.getIdList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findVisit(QueryResultVisitor<T> visitor) {
        QueryIterator it = this.queryEngine.findIterate(this);
        try {
            while (it.hasNext() && visitor.accept(it.next())) {
            }
        }
        finally {
            it.close();
        }
    }

    @Override
    public QueryIterator<T> findIterate() {
        return this.queryEngine.findIterate(this);
    }

    @Override
    public List<T> findList() {
        return (List)((Object)this.queryEngine.findMany(this));
    }

    @Override
    public Set<?> findSet() {
        return (Set)((Object)this.queryEngine.findMany(this));
    }

    @Override
    public Map<?, ?> findMap() {
        String mapKey = this.query.getMapKey();
        if (mapKey == null) {
            BeanProperty idProp = this.beanDescriptor.getIdProperty();
            if (idProp != null) {
                this.query.setMapKey(idProp.getName());
            } else {
                throw new PersistenceException("No mapKey specified for query");
            }
        }
        return (Map)((Object)this.queryEngine.findMany(this));
    }

    public SpiQuery.Type getQueryType() {
        return this.query.getType();
    }

    public BeanFinder<T> getBeanFinder() {
        return this.finder;
    }

    @Override
    public SpiQuery<T> getQuery() {
        return this.query;
    }

    public BeanPropertyAssocMany<?> getManyProperty() {
        return this.beanDescriptor.getManyProperty(this.query);
    }

    public CQueryPlan getQueryPlan() {
        return this.beanDescriptor.getQueryPlan(this.queryPlanHash);
    }

    public HashQueryPlan getQueryPlanHash() {
        return this.queryPlanHash;
    }

    public void putQueryPlan(CQueryPlan queryPlan) {
        this.beanDescriptor.putQueryPlan(this.queryPlanHash, queryPlan);
    }

    public boolean isUseBeanCache() {
        return this.beanDescriptor.calculateUseCache(this.query.isUseBeanCache());
    }

    @Override
    public BeanCollection<T> getFromQueryCache() {
        if (!this.query.isUseQueryCache()) {
            return null;
        }
        this.cacheKey = this.query.queryHash();
        return this.beanDescriptor.queryCacheGet(this.cacheKey);
    }

    public void putToQueryCache(BeanCollection<T> queryResult) {
        this.beanDescriptor.queryCachePut(this.cacheKey, queryResult);
    }

    public void setCancelableQuery(CancelableQuery cancelableQuery) {
        this.query.setCancelableQuery(cancelableQuery);
    }

    public void logSql(String sql) {
        this.transaction.logSql(sql);
    }

    public boolean isLogSecondaryQuery() {
        return this.query.isLogSecondaryQuery();
    }
}

