/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cache;

import java.util.Arrays;

public class CachedBeanData {
    private final long whenCreated = System.currentTimeMillis();
    private final Object sharableBean;
    private final boolean[] loaded;
    private final Object[] data;
    private final boolean naturalKeyUpdate;
    private final Object naturalKey;
    private final Object oldNaturalKey;

    public CachedBeanData(Object sharableBean, boolean[] loaded, Object[] data, Object naturalKey, Object oldNaturalKey) {
        this.sharableBean = sharableBean;
        this.loaded = loaded;
        this.data = data;
        this.naturalKeyUpdate = naturalKey != null;
        this.naturalKey = naturalKey != null ? naturalKey : oldNaturalKey;
        this.oldNaturalKey = oldNaturalKey;
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public Object[] copyData() {
        Object[] dest = new Object[this.data.length];
        System.arraycopy(this.data, 0, dest, 0, this.data.length);
        return dest;
    }

    public boolean[] copyLoaded() {
        boolean[] dest = new boolean[this.data.length];
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = this.loaded[i];
        }
        return dest;
    }

    public long getWhenCreated() {
        return this.whenCreated;
    }

    public Object getSharableBean() {
        return this.sharableBean;
    }

    public boolean isNaturalKeyUpdate() {
        return this.naturalKeyUpdate;
    }

    public Object getNaturalKey() {
        return this.naturalKey;
    }

    public Object getOldNaturalKey() {
        return this.oldNaturalKey;
    }

    public Object getData(int i) {
        return this.data[i];
    }

    public boolean isLoaded(int i) {
        return this.loaded[i];
    }
}

