/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.common;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.BeanCollectionLoader;
import com.avaje.ebean.bean.BeanCollectionTouched;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.ModifyHolder;
import java.util.Set;
import javax.persistence.PersistenceException;

public abstract class AbstractBeanCollection<E>
implements BeanCollection<E> {
    private static final long serialVersionUID = 3365725236140187588L;
    protected boolean readOnly;
    protected transient BeanCollectionLoader loader;
    protected transient ExpressionList<?> filterMany;
    protected int loaderIndex;
    protected String ebeanServerName;
    protected transient BeanCollectionTouched beanCollectionTouched;
    protected final EntityBean ownerBean;
    protected final String propertyName;
    protected ModifyHolder<E> modifyHolder;
    protected BeanCollection.ModifyListenMode modifyListenMode;
    protected boolean modifyAddListening;
    protected boolean modifyRemoveListening;
    protected boolean modifyListening;
    protected boolean touched;

    public AbstractBeanCollection() {
        this.ownerBean = null;
        this.propertyName = null;
    }

    public AbstractBeanCollection(BeanCollectionLoader loader, EntityBean ownerBean, String propertyName) {
        this.loader = loader;
        this.ebeanServerName = loader.getName();
        this.ownerBean = ownerBean;
        this.propertyName = propertyName;
        this.readOnly = ownerBean._ebean_getIntercept().isReadOnly();
    }

    @Override
    public EntityBean getOwnerBean() {
        return this.ownerBean;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public int getLoaderIndex() {
        return this.loaderIndex;
    }

    @Override
    public ExpressionList<?> getFilterMany() {
        return this.filterMany;
    }

    @Override
    public void setFilterMany(ExpressionList<?> filterMany) {
        this.filterMany = filterMany;
    }

    protected void lazyLoadCollection(boolean onlyIds) {
        if (this.loader == null) {
            this.loader = (BeanCollectionLoader)((Object)Ebean.getServer(this.ebeanServerName));
        }
        if (this.loader == null) {
            String msg = "Lazy loading but LazyLoadEbeanServer is null? The LazyLoadEbeanServer needs to be set after deserialization to support lazy loading.";
            throw new PersistenceException(msg);
        }
        this.loader.loadMany(this, onlyIds);
        this.checkEmptyLazyLoad();
    }

    protected void touched(boolean setFlag) {
        if (setFlag) {
            this.touched = true;
        }
        if (this.beanCollectionTouched != null) {
            this.beanCollectionTouched.notifyTouched(this);
            this.beanCollectionTouched = null;
        }
    }

    @Override
    public void setBeanCollectionTouched(BeanCollectionTouched notify) {
        this.beanCollectionTouched = notify;
    }

    @Override
    public void setLoader(int beanLoaderIndex, BeanCollectionLoader loader) {
        this.loaderIndex = beanLoaderIndex;
        this.loader = loader;
        this.ebeanServerName = loader.getName();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    protected void checkReadOnly() {
        if (this.readOnly) {
            String msg = "This collection is in ReadOnly mode";
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void setModifyListening(BeanCollection.ModifyListenMode mode) {
        this.modifyListenMode = mode;
        this.modifyAddListening = BeanCollection.ModifyListenMode.ALL.equals((Object)mode);
        this.modifyRemoveListening = this.modifyAddListening || BeanCollection.ModifyListenMode.REMOVALS.equals((Object)mode);
        boolean bl = this.modifyListening = this.modifyRemoveListening || this.modifyAddListening;
        if (this.modifyListening) {
            this.modifyHolder = null;
        }
    }

    public BeanCollection.ModifyListenMode getModifyListenMode() {
        return this.modifyListenMode;
    }

    protected ModifyHolder<E> getModifyHolder() {
        if (this.modifyHolder == null) {
            this.modifyHolder = new ModifyHolder();
        }
        return this.modifyHolder;
    }

    @Override
    public void modifyAddition(E bean) {
        if (this.modifyAddListening) {
            this.getModifyHolder().modifyAddition(bean);
        }
    }

    @Override
    public void modifyRemoval(Object bean) {
        if (this.modifyRemoveListening) {
            this.getModifyHolder().modifyRemoval(bean);
        }
    }

    @Override
    public void modifyReset() {
        if (this.modifyHolder != null) {
            this.modifyHolder.reset();
        }
    }

    @Override
    public Set<E> getModifyAdditions() {
        if (this.modifyHolder == null) {
            return null;
        }
        return this.modifyHolder.getModifyAdditions();
    }

    @Override
    public Set<E> getModifyRemovals() {
        if (this.modifyHolder == null) {
            return null;
        }
        return this.modifyHolder.getModifyRemovals();
    }
}

