/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.bean;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.ValuePair;
import com.avaje.ebean.bean.BeanLoader;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.NodeUsageCollector;
import com.avaje.ebean.bean.PersistenceContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceException;

public final class EntityBeanIntercept
implements Serializable {
    private static final long serialVersionUID = -3664031775464862649L;
    private static final int STATE_NEW = 0;
    private static final int STATE_REFERENCE = 1;
    private static final int STATE_LOADED = 2;
    private transient NodeUsageCollector nodeUsageCollector;
    private transient PropertyChangeSupport pcs;
    private transient PersistenceContext persistenceContext;
    private transient BeanLoader beanLoader;
    private int beanLoaderIndex;
    private String ebeanServerName;
    private EntityBean owner;
    private EntityBean embeddedOwner;
    private int embeddedOwnerIndex;
    private int state;
    private boolean readOnly;
    private boolean dirty;
    private boolean disableLazyLoad;
    private boolean lazyLoadFailure;
    private boolean[] loadedProps;
    private boolean fullyLoadedBean;
    private boolean[] changedProps;
    private boolean[] embeddedDirty;
    private Object[] origValues;
    private int lazyLoadProperty = -1;

    public EntityBeanIntercept(Object ownerBean) {
        this.owner = (EntityBean)ownerBean;
        this.loadedProps = new boolean[this.owner._ebean_getPropertyNames().length];
    }

    public EntityBean getOwner() {
        return this.owner;
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public void setPersistenceContext(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this.owner);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this.owner);
        }
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyName, listener);
        }
    }

    public void setNodeUsageCollector(NodeUsageCollector usageCollector) {
        this.nodeUsageCollector = usageCollector;
    }

    public Object getEmbeddedOwner() {
        return this.embeddedOwner;
    }

    public int getEmbeddedOwnerIndex() {
        return this.embeddedOwnerIndex;
    }

    public void setEmbeddedOwner(EntityBean parentBean, int embeddedOwnerIndex) {
        this.embeddedOwner = parentBean;
        this.embeddedOwnerIndex = embeddedOwnerIndex;
    }

    public int getBeanLoaderIndex() {
        return this.beanLoaderIndex;
    }

    public void setBeanLoaderByServerName(String ebeanServerName) {
        this.beanLoaderIndex = 0;
        this.beanLoader = null;
        this.ebeanServerName = ebeanServerName;
    }

    public void setBeanLoader(int index, BeanLoader beanLoader, PersistenceContext ctx) {
        this.beanLoaderIndex = index;
        this.beanLoader = beanLoader;
        this.persistenceContext = ctx;
        this.ebeanServerName = beanLoader.getName();
    }

    public boolean isFullyLoadedBean() {
        return this.fullyLoadedBean;
    }

    public void setFullyLoadedBean(boolean fullyLoadedBean) {
        this.fullyLoadedBean = fullyLoadedBean;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setEmbeddedDirty(int embeddedProperty) {
        this.dirty = true;
        this.setEmbeddedPropertyDirty(embeddedProperty);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isNew() {
        return this.state == 0;
    }

    public boolean isNewOrDirty() {
        return this.isNew() || this.isDirty();
    }

    public boolean hasIdOnly(int idIndex) {
        for (int i = 0; i < this.loadedProps.length; ++i) {
            if (!(i == idIndex ? !this.loadedProps[i] : this.loadedProps[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isReference() {
        return this.state == 1;
    }

    public void setReference(int idPos) {
        this.state = 1;
        if (idPos > -1) {
            for (int i = 0; i < this.loadedProps.length; ++i) {
                if (i == idPos) continue;
                this.loadedProps[i] = false;
            }
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isLoaded() {
        return this.state == 2;
    }

    public void setLoaded() {
        this.state = 2;
        this.owner._ebean_setEmbeddedLoaded();
        this.lazyLoadProperty = -1;
        this.origValues = null;
        this.changedProps = null;
        this.dirty = false;
    }

    public void setLoadedLazy() {
        this.state = 2;
        this.lazyLoadProperty = -1;
    }

    public void checkLazyLoadFailure() {
        if (this.lazyLoadProperty != -1) {
            this.lazyLoadFailure = true;
        }
    }

    public boolean isLazyLoadFailure() {
        return this.lazyLoadFailure;
    }

    public boolean isDisableLazyLoad() {
        return this.disableLazyLoad;
    }

    public void setDisableLazyLoad(boolean disableLazyLoad) {
        this.disableLazyLoad = disableLazyLoad;
    }

    public void setEmbeddedLoaded(Object embeddedBean) {
        if (embeddedBean instanceof EntityBean) {
            EntityBean eb = (EntityBean)embeddedBean;
            eb._ebean_getIntercept().setLoaded();
        }
    }

    public boolean isEmbeddedNewOrDirty(Object embeddedBean) {
        if (embeddedBean == null) {
            return false;
        }
        if (embeddedBean instanceof EntityBean) {
            return ((EntityBean)embeddedBean)._ebean_getIntercept().isNewOrDirty();
        }
        return true;
    }

    public Object getOrigValue(int propertyIndex) {
        if (this.origValues == null) {
            return null;
        }
        return this.origValues[propertyIndex];
    }

    public int findProperty(String propertyName) {
        String[] names = this.owner._ebean_getPropertyNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(propertyName)) continue;
            return i;
        }
        return -1;
    }

    public String getProperty(int propertyIndex) {
        if (propertyIndex == -1) {
            return null;
        }
        return this.owner._ebean_getPropertyName(propertyIndex);
    }

    public int getPropertyLength() {
        return this.owner._ebean_getPropertyNames().length;
    }

    public void setPropertyUnloaded(int propertyIndex) {
        this.loadedProps[propertyIndex] = false;
    }

    public void setLoadedProperty(int propertyIndex) {
        this.loadedProps[propertyIndex] = true;
    }

    public boolean isLoadedProperty(int propertyIndex) {
        return this.loadedProps[propertyIndex];
    }

    public boolean isChangedProperty(int propertyIndex) {
        return this.changedProps != null && this.changedProps[propertyIndex];
    }

    public boolean isDirtyProperty(int propertyIndex) {
        return this.changedProps != null && this.changedProps[propertyIndex] || this.embeddedDirty != null && this.embeddedDirty[propertyIndex];
    }

    public void markPropertyAsChanged(int propertyIndex) {
        this.setChangedProperty(propertyIndex);
        this.setDirty(true);
    }

    private void setChangedProperty(int propertyIndex) {
        if (this.changedProps == null) {
            this.changedProps = new boolean[this.owner._ebean_getPropertyNames().length];
        }
        this.changedProps[propertyIndex] = true;
    }

    private void setEmbeddedPropertyDirty(int propertyIndex) {
        if (this.embeddedDirty == null) {
            this.embeddedDirty = new boolean[this.owner._ebean_getPropertyNames().length];
        }
        this.embeddedDirty[propertyIndex] = true;
    }

    private void setOriginalValue(int propertyIndex, Object value) {
        if (this.origValues == null) {
            this.origValues = new Object[this.owner._ebean_getPropertyNames().length];
        }
        if (this.origValues[propertyIndex] == null) {
            this.origValues[propertyIndex] = value;
        }
    }

    public void setNewBeanForUpdate() {
        if (this.changedProps == null) {
            this.changedProps = new boolean[this.owner._ebean_getPropertyNames().length];
        }
        for (int i = 0; i < this.loadedProps.length; ++i) {
            if (!this.loadedProps[i]) continue;
            this.changedProps[i] = true;
        }
        this.setDirty(true);
    }

    public Set<String> getLoadedPropertyNames() {
        if (this.fullyLoadedBean) {
            return null;
        }
        LinkedHashSet<String> props = new LinkedHashSet<String>();
        for (int i = 0; i < this.loadedProps.length; ++i) {
            if (!this.loadedProps[i]) continue;
            props.add(this.getProperty(i));
        }
        return props;
    }

    public Set<String> getDirtyPropertyNames() {
        LinkedHashSet<String> props = new LinkedHashSet<String>();
        this.addDirtyPropertyNames(props, null);
        return props;
    }

    public void addDirtyPropertyNames(Set<String> props, String prefix) {
        int len = this.getPropertyLength();
        for (int i = 0; i < len; ++i) {
            if (this.changedProps != null && this.changedProps[i]) {
                String propName = prefix == null ? this.getProperty(i) : prefix + this.getProperty(i);
                props.add(propName);
                continue;
            }
            if (this.embeddedDirty == null || !this.embeddedDirty[i]) continue;
            EntityBean embeddedBean = (EntityBean)this.owner._ebean_getField(i);
            embeddedBean._ebean_getIntercept().addDirtyPropertyNames(props, this.getProperty(i) + ".");
        }
    }

    public Map<String, ValuePair> getDirtyValues() {
        LinkedHashMap<String, ValuePair> dirtyValues = new LinkedHashMap<String, ValuePair>();
        this.addDirtyPropertyValues(dirtyValues, null);
        return dirtyValues;
    }

    public void addDirtyPropertyValues(Map<String, ValuePair> dirtyValues, String prefix) {
        int len = this.getPropertyLength();
        for (int i = 0; i < len; ++i) {
            if (this.changedProps != null && this.changedProps[i]) {
                String propName = prefix == null ? this.getProperty(i) : prefix + this.getProperty(i);
                Object newVal = this.owner._ebean_getField(i);
                Object oldVal = this.getOrigValue(i);
                dirtyValues.put(propName, new ValuePair(newVal, oldVal));
                continue;
            }
            if (this.embeddedDirty == null || !this.embeddedDirty[i]) continue;
            EntityBean embeddedBean = (EntityBean)this.owner._ebean_getField(i);
            embeddedBean._ebean_getIntercept().addDirtyPropertyValues(dirtyValues, this.getProperty(i) + ".");
        }
    }

    public int getDirtyPropertyHash() {
        return this.addDirtyPropertyHash(37);
    }

    public int addDirtyPropertyHash(int hash) {
        int len = this.getPropertyLength();
        for (int i = 0; i < len; ++i) {
            if (this.changedProps != null && this.changedProps[i]) {
                hash = hash * 31 + (i + 1);
                continue;
            }
            if (this.embeddedDirty == null || !this.embeddedDirty[i]) continue;
            EntityBean embeddedBean = (EntityBean)this.owner._ebean_getField(i);
            hash = hash * 31 + embeddedBean._ebean_getIntercept().addDirtyPropertyHash(hash);
        }
        return hash;
    }

    public boolean[] getChanged() {
        return this.changedProps;
    }

    public boolean[] getLoaded() {
        return this.loadedProps;
    }

    public int getLazyLoadPropertyIndex() {
        return this.lazyLoadProperty;
    }

    public String getLazyLoadProperty() {
        return this.getProperty(this.lazyLoadProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBean(int loadProperty) {
        Object object = this;
        synchronized (object) {
            if (this.beanLoader == null) {
                BeanLoader serverLoader = (BeanLoader)((Object)Ebean.getServer(this.ebeanServerName));
                if (serverLoader == null) {
                    throw new PersistenceException("Server [" + this.ebeanServerName + "] was not found?");
                }
                this.loadBeanInternal(loadProperty, serverLoader);
                return;
            }
        }
        object = this.beanLoader;
        synchronized (object) {
            this.loadBeanInternal(loadProperty, this.beanLoader);
        }
    }

    private void loadBeanInternal(int loadProperty, BeanLoader loader) {
        if (this.loadedProps == null || this.loadedProps[loadProperty]) {
            return;
        }
        if (this.lazyLoadFailure) {
            throw new EntityNotFoundException("Bean has been deleted - lazy loading failed");
        }
        if (this.lazyLoadProperty == -1) {
            this.lazyLoadProperty = loadProperty;
            if (this.nodeUsageCollector != null) {
                this.nodeUsageCollector.setLoadProperty(this.getProperty(this.lazyLoadProperty));
            }
            loader.loadBean(this);
            if (this.lazyLoadFailure) {
                throw new EntityNotFoundException("Bean has been deleted - lazy loading failed");
            }
        }
    }

    protected boolean areEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 instanceof BigDecimal) {
            if (obj2 instanceof BigDecimal) {
                Comparable com1 = (Comparable)obj1;
                return com1.compareTo(obj2) == 0;
            }
            return false;
        }
        if (obj1 instanceof URL) {
            return obj1.toString().equals(obj2.toString());
        }
        return obj1.equals(obj2);
    }

    public void initialisedMany(int propertyIndex) {
        this.loadedProps[propertyIndex] = true;
    }

    public void preGetter(int propertyIndex) {
        if (this.state == 0 || this.disableLazyLoad) {
            return;
        }
        if (!this.isLoadedProperty(propertyIndex)) {
            this.loadBean(propertyIndex);
        }
        if (this.nodeUsageCollector != null) {
            this.nodeUsageCollector.addUsed(this.getProperty(propertyIndex));
        }
    }

    public void postSetter(PropertyChangeEvent event) {
        if (this.pcs != null && event != null) {
            this.pcs.firePropertyChange(event);
        }
    }

    public void postSetter(PropertyChangeEvent event, Object newValue) {
        if (this.pcs != null && event != null) {
            if (newValue != null && newValue.equals(event.getNewValue())) {
                this.pcs.firePropertyChange(event);
            } else {
                this.pcs.firePropertyChange(event.getPropertyName(), event.getOldValue(), newValue);
            }
        }
    }

    public PropertyChangeEvent preSetterMany(boolean interceptField, int propertyIndex, Object oldValue, Object newValue) {
        if (this.readOnly) {
            throw new IllegalStateException("This bean is readOnly");
        }
        this.setLoadedProperty(propertyIndex);
        if (this.pcs != null) {
            return new PropertyChangeEvent(this.owner, this.getProperty(propertyIndex), oldValue, newValue);
        }
        return null;
    }

    private void setChangedPropertyValue(int propertyIndex, boolean setDirtyState, Object origValue) {
        if (this.readOnly) {
            throw new IllegalStateException("This bean is readOnly");
        }
        this.setChangedProperty(propertyIndex);
        if (setDirtyState) {
            this.setOriginalValue(propertyIndex, origValue);
            if (!this.dirty) {
                this.dirty = true;
                if (this.embeddedOwner != null) {
                    this.embeddedOwner._ebean_getIntercept().setEmbeddedDirty(this.embeddedOwnerIndex);
                }
                if (this.nodeUsageCollector != null) {
                    this.nodeUsageCollector.setModified();
                }
            }
        }
    }

    public PropertyChangeEvent preSetter(boolean intercept, int propertyIndex, Object oldValue, Object newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (!this.areEqual(oldValue, newValue)) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        } else {
            return null;
        }
        return this.pcs == null ? null : new PropertyChangeEvent(this.owner, this.getProperty(propertyIndex), oldValue, newValue);
    }

    public PropertyChangeEvent preSetter(boolean intercept, int propertyIndex, boolean oldValue, boolean newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        } else {
            return null;
        }
        return this.pcs == null ? null : new PropertyChangeEvent(this.owner, this.getProperty(propertyIndex), oldValue, newValue);
    }

    public PropertyChangeEvent preSetter(boolean intercept, int propertyIndex, int oldValue, int newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        } else {
            return null;
        }
        return this.pcs == null ? null : new PropertyChangeEvent(this.owner, this.getProperty(propertyIndex), oldValue, newValue);
    }

    public PropertyChangeEvent preSetter(boolean intercept, int propertyIndex, long oldValue, long newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        } else {
            return null;
        }
        return this.pcs == null ? null : new PropertyChangeEvent(this.owner, this.getProperty(propertyIndex), oldValue, newValue);
    }

    public PropertyChangeEvent preSetter(boolean intercept, int propertyIndex, double oldValue, double newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        } else {
            return null;
        }
        return this.pcs == null ? null : new PropertyChangeEvent(this.owner, this.getProperty(propertyIndex), oldValue, newValue);
    }

    public PropertyChangeEvent preSetter(boolean intercept, int propertyIndex, float oldValue, float newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, Float.valueOf(oldValue));
        } else {
            return null;
        }
        return this.pcs == null ? null : new PropertyChangeEvent(this.owner, this.getProperty(propertyIndex), Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public PropertyChangeEvent preSetter(boolean intercept, int propertyIndex, short oldValue, short newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        } else {
            return null;
        }
        return this.pcs == null ? null : new PropertyChangeEvent(this.owner, this.getProperty(propertyIndex), oldValue, newValue);
    }

    public PropertyChangeEvent preSetter(boolean intercept, int propertyIndex, char oldValue, char newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, Character.valueOf(oldValue));
        } else {
            return null;
        }
        return this.pcs == null ? null : new PropertyChangeEvent(this.owner, this.getProperty(propertyIndex), Character.valueOf(oldValue), Character.valueOf(newValue));
    }

    public PropertyChangeEvent preSetter(boolean intercept, int propertyIndex, byte oldValue, byte newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        } else {
            return null;
        }
        return this.pcs == null ? null : new PropertyChangeEvent(this.owner, this.getProperty(propertyIndex), oldValue, newValue);
    }

    public PropertyChangeEvent preSetter(boolean intercept, int propertyIndex, char[] oldValue, char[] newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (!EntityBeanIntercept.areEqualChars(oldValue, newValue)) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        } else {
            return null;
        }
        return this.pcs == null ? null : new PropertyChangeEvent(this.owner, this.getProperty(propertyIndex), oldValue, newValue);
    }

    public PropertyChangeEvent preSetter(boolean intercept, int propertyIndex, byte[] oldValue, byte[] newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (!EntityBeanIntercept.areEqualBytes(oldValue, newValue)) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        } else {
            return null;
        }
        return this.pcs == null ? null : new PropertyChangeEvent(this.owner, this.getProperty(propertyIndex), oldValue, newValue);
    }

    private static boolean areEqualBytes(byte[] b1, byte[] b2) {
        if (b1 == null) {
            return b2 == null;
        }
        if (b2 == null) {
            return false;
        }
        if (b1 == b2) {
            return true;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean areEqualChars(char[] b1, char[] b2) {
        if (b1 == null) {
            return b2 == null;
        }
        if (b2 == null) {
            return false;
        }
        if (b1 == b2) {
            return true;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }
}

