/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.agentloader;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.tools.attach.BsdVirtualMachine;
import sun.tools.attach.LinuxVirtualMachine;
import sun.tools.attach.SolarisVirtualMachine;
import sun.tools.attach.WindowsVirtualMachine;

public class AgentLoader {
    private static final Logger log = LoggerFactory.getLogger(AgentLoader.class);
    private static final List<String> loaded = new ArrayList<String>();
    private static final int IO_BUFFER_SIZE = 4096;
    private static final AttachProvider ATTACH_PROVIDER = new AttachProvider(){

        @Override
        public String name() {
            return null;
        }

        @Override
        public String type() {
            return null;
        }

        @Override
        public VirtualMachine attachVirtualMachine(String id) {
            return null;
        }

        @Override
        public List<VirtualMachineDescriptor> listVirtualMachines() {
            return null;
        }
    };

    private static final String discoverPid() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        return nameOfRunningVM.substring(0, p);
    }

    public static void loadAgent(String jarFilePath) {
        AgentLoader.loadAgent(jarFilePath, "");
    }

    public static void loadAgent(String jarFilePath, String params) {
        log.info("dynamically loading javaagent for " + jarFilePath);
        try {
            String pid = AgentLoader.discoverPid();
            VirtualMachine vm = AttachProvider.providers().isEmpty() ? AgentLoader.getVirtualMachineImplementationFromEmbeddedOnes(pid) : VirtualMachine.attach(pid);
            vm.loadAgent(jarFilePath, params);
            vm.detach();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadAgentFromClasspath(String agentName) {
        AgentLoader.loadAgentFromClasspath(agentName, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean loadAgentFromClasspath(String agentName, String params) {
        if (loaded.contains(agentName)) {
            return true;
        }
        try {
            if (!(AgentLoader.class.getClassLoader() instanceof URLClassLoader)) return false;
            URLClassLoader cl = (URLClassLoader)AgentLoader.class.getClassLoader();
            URL[] uRLArray = cl.getURLs();
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                if (AgentLoader.isMatch(url, agentName)) {
                    String fullName = url.toURI().getPath();
                    boolean isEmbedded = false;
                    if (AgentLoader.isAgentEmbeddedInJar(url, fullName)) {
                        fullName = AgentLoader.extractJar(url, agentName);
                        isEmbedded = true;
                    }
                    if (fullName != null && !loaded.contains(fullName)) {
                        if (fullName.startsWith("/") && AgentLoader.isWindows()) {
                            fullName = fullName.substring(1);
                        }
                        try {
                            AgentLoader.loadAgent(fullName, params);
                            loaded.add(fullName);
                            boolean bl = true;
                            return bl;
                        }
                        finally {
                            if (isEmbedded) {
                                try {
                                    new File(fullName).delete();
                                }
                                catch (Exception ex) {
                                    log.warn("Cannot delete Agent file from JVM temporary folder", (Throwable)ex);
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
            return false;
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
    }

    private static boolean isAgentEmbeddedInJar(URL url, String fullName) {
        return fullName == null && url.getProtocol().equals("jar") && url.getPath().contains("!/");
    }

    private static boolean isMatch(URL url, String partial) {
        String fullPath = url.getFile();
        int lastSlash = fullPath.lastIndexOf(47);
        if (lastSlash < 0) {
            return false;
        }
        return fullPath.contains(partial);
    }

    private static final boolean isWindows() {
        return File.separatorChar == '\\';
    }

    private static boolean isEmbededJar(String path) {
        return path.endsWith(".jar!/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractJar(URL path, String agentName) {
        String fullPath = null;
        OutputStream outputJar = null;
        ZipFile inputZip = null;
        log.debug("Extracting agent {} from source {}", (Object)agentName, (Object)path.getPath());
        try {
            String[] jarNames = path.getPath().split(":");
            String[] packageFileAndFileOffset = jarNames[1].split("!/");
            fullPath = System.getProperty("java.io.tmpdir") + "/" + agentName + ".jar";
            String packageFile = packageFileAndFileOffset[0];
            String fileOffset = packageFileAndFileOffset[1];
            inputZip = new JarFile(packageFile);
            boolean isJarFile = AgentLoader.isEmbededJar(jarNames[1]);
            outputJar = isJarFile ? new FileOutputStream(fullPath) : new JarOutputStream(new FileOutputStream(fullPath));
            AgentLoader.exportFile((JarFile)inputZip, outputJar, fileOffset, isJarFile);
            log.debug("Extracted agent to {}", (Object)fullPath);
        }
        catch (Exception ex) {
            log.error("Failed to export agent " + agentName, (Throwable)ex);
        }
        finally {
            if (outputJar != null) {
                try {
                    outputJar.close();
                }
                catch (IOException ioEx) {
                    log.error("Error closing Agent JarFile", (Throwable)ioEx);
                }
            }
            if (inputZip != null) {
                try {
                    inputZip.close();
                }
                catch (IOException ioEx) {
                    log.error("Error closing input JarFile", (Throwable)ioEx);
                }
            }
        }
        return fullPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void exportFile(JarFile source, OutputStream target, String partial, boolean isJar) throws NoSuchFieldException, IllegalAccessException, IOException {
        Enumeration<JarEntry> entries = source.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(partial)) continue;
            log.debug("copying {} to output", (Object)entry.getName());
            if (isJar) {
                AgentLoader.copyBytes(source.getInputStream(entry), target);
                break;
            }
            String internalName = entry.getName().substring(partial.length());
            JarEntry ze = new JarEntry(entry);
            Field f = ze.getClass().getSuperclass().getDeclaredField("name");
            f.setAccessible(true);
            f.set(ze, internalName);
            try {
                ((JarOutputStream)target).putNextEntry(ze);
                AgentLoader.copyBytes(source.getInputStream(entry), target);
            }
            finally {
                ((JarOutputStream)target).closeEntry();
            }
        }
    }

    protected static long copyBytes(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private static VirtualMachine getVirtualMachineImplementationFromEmbeddedOnes(String pid) {
        try {
            if (AgentLoader.isWindows()) {
                return new WindowsVirtualMachine(ATTACH_PROVIDER, pid);
            }
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Linux") || osName.startsWith("LINUX")) {
                return new LinuxVirtualMachine(ATTACH_PROVIDER, pid);
            }
            if (osName.startsWith("Mac OS X")) {
                return new BsdVirtualMachine(ATTACH_PROVIDER, pid);
            }
            if (osName.startsWith("Solaris")) {
                return new SolarisVirtualMachine(ATTACH_PROVIDER, pid);
            }
        }
        catch (AttachNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (UnsatisfiedLinkError e) {
            throw new IllegalStateException("Native library for Attach API not available in this JRE", e);
        }
        return null;
    }
}

