/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.attach;

import com.sun.tools.attach.spi.AttachProvider;

public class VirtualMachineDescriptor {
    private AttachProvider provider;
    private String id;
    private String displayName;
    private volatile int hash;

    public VirtualMachineDescriptor(AttachProvider provider, String id, String displayName) {
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        if (id == null) {
            throw new NullPointerException("identifier cannot be null");
        }
        if (displayName == null) {
            throw new NullPointerException("display name cannot be null");
        }
        this.provider = provider;
        this.id = id;
        this.displayName = displayName;
    }

    public VirtualMachineDescriptor(AttachProvider provider, String id) {
        this(provider, id, id);
    }

    public AttachProvider provider() {
        return this.provider;
    }

    public String id() {
        return this.id;
    }

    public String displayName() {
        return this.displayName;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.provider.hashCode() * 127 + this.id.hashCode();
        return this.hash;
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof VirtualMachineDescriptor)) {
            return false;
        }
        VirtualMachineDescriptor other = (VirtualMachineDescriptor)ob;
        if (other.provider() != this.provider()) {
            return false;
        }
        return other.id().equals(this.id());
    }

    public String toString() {
        String s = this.provider.toString() + ": " + this.id;
        if (this.displayName != this.id) {
            s = s + " " + this.displayName;
        }
        return s;
    }
}

