/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import org.assertj.core.presentation.DefaultToString;
import org.assertj.core.presentation.NumberGrouping;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Strings;

public class BinaryRepresentation
implements Representation {
    public static final String BYTE_PREFIX = "0b";

    @Override
    public String toStringOf(Object object) {
        if (object instanceof Character) {
            return BinaryRepresentation.toStringOf((Character)object);
        }
        if (object instanceof Number) {
            return BinaryRepresentation.toStringOf((Number)object);
        }
        if (object instanceof String) {
            return BinaryRepresentation.toStringOf(this, (String)object);
        }
        return DefaultToString.toStringOf(this, object);
    }

    private static String toStringOf(Representation representation, String s) {
        return Strings.concat("\"", representation.toStringOf(s.toCharArray()), "\"");
    }

    private static String toStringOf(Number number) {
        if (number instanceof Byte) {
            return BinaryRepresentation.toStringOf((Byte)number);
        }
        if (number instanceof Short) {
            return BinaryRepresentation.toStringOf((Short)number);
        }
        if (number instanceof Integer) {
            return BinaryRepresentation.toStringOf((Integer)number);
        }
        if (number instanceof Long) {
            return BinaryRepresentation.toStringOf((Long)number);
        }
        if (number instanceof Float) {
            return BinaryRepresentation.toStringOf((Float)number);
        }
        if (number instanceof Double) {
            return BinaryRepresentation.toStringOf((Double)number);
        }
        return number == null ? null : number.toString();
    }

    private static String toStringOf(Byte b) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(b & 0xFF), 8);
    }

    private static String toStringOf(Short s) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(s & 0xFFFF), 16);
    }

    private static String toStringOf(Integer i) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(i), 32);
    }

    private static String toStringOf(Long l) {
        return BinaryRepresentation.toGroupedBinary(Long.toBinaryString(l), 64);
    }

    private static String toStringOf(Float f) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(Float.floatToIntBits(f.floatValue())), 32);
    }

    private static String toStringOf(Double d) {
        return BinaryRepresentation.toGroupedBinary(Long.toBinaryString(Double.doubleToRawLongBits(d)), 64);
    }

    private static String toStringOf(Character character) {
        return Strings.concat("'", BinaryRepresentation.toStringOf((short)character.charValue()), "'");
    }

    private static String toGroupedBinary(String value, int size) {
        return BYTE_PREFIX + NumberGrouping.toBinaryLiteral(BinaryRepresentation.toBinary(value, size));
    }

    private static String toBinary(String value, int size) {
        return String.format("%" + size + "s", value).replace(' ', '0');
    }
}

