/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Offset;
import org.assertj.core.error.ShouldBeEqualWithinOffset;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Numbers;
import org.assertj.core.util.VisibleForTesting;

public class Bytes
extends Numbers<Byte> {
    private static final Bytes INSTANCE = new Bytes();

    public static Bytes instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Bytes() {
    }

    public Bytes(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected Byte zero() {
        return (byte)0;
    }

    @Override
    public void assertIsCloseTo(AssertionInfo info, Byte actual, Byte expected, Offset<Byte> offset) {
        Bytes.assertNotNull(info, actual);
        CommonValidations.checkOffsetIsNotNull(offset);
        CommonValidations.checkNumberIsNotNull(expected);
        byte absDiff = (byte)Math.abs(expected - actual);
        if (absDiff > (Byte)offset.value) {
            throw this.failures.failure(info, ShouldBeEqualWithinOffset.shouldBeEqual(actual, expected, offset, absDiff));
        }
    }
}

