/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.LocalDate;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualsTo;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;

public abstract class AbstractLocalDateAssert<S extends AbstractLocalDateAssert<S>>
extends AbstractAssert<S, LocalDate> {
    public static final String NULL_LOCAL_DATE_TIME_PARAMETER_MESSAGE = "The LocalDate to compare actual with should not be null";

    protected AbstractLocalDateAssert(LocalDate actual, Class<?> selfType) {
        super(actual, selfType);
    }

    protected LocalDate getActual() {
        return (LocalDate)this.actual;
    }

    public S isBefore(LocalDate other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateAssert.assertLocalDateParameterIsNotNull(other);
        if (!((LocalDate)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (S)((AbstractLocalDateAssert)this.myself);
    }

    public S isBefore(String localDateTimeAsString) {
        AbstractLocalDateAssert.assertLocalDateAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isBefore(LocalDate.parse(localDateTimeAsString));
    }

    public S isBeforeOrEqualTo(LocalDate other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateAssert.assertLocalDateParameterIsNotNull(other);
        if (((LocalDate)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return (S)((AbstractLocalDateAssert)this.myself);
    }

    public S isBeforeOrEqualTo(String localDateTimeAsString) {
        AbstractLocalDateAssert.assertLocalDateAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isBeforeOrEqualTo(LocalDate.parse(localDateTimeAsString));
    }

    public S isAfterOrEqualTo(LocalDate other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateAssert.assertLocalDateParameterIsNotNull(other);
        if (((LocalDate)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return (S)((AbstractLocalDateAssert)this.myself);
    }

    public S isAfterOrEqualTo(String localDateTimeAsString) {
        AbstractLocalDateAssert.assertLocalDateAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isAfterOrEqualTo(LocalDate.parse(localDateTimeAsString));
    }

    public S isAfter(LocalDate other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateAssert.assertLocalDateParameterIsNotNull(other);
        if (!((LocalDate)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (S)((AbstractLocalDateAssert)this.myself);
    }

    public S isAfter(String localDateTimeAsString) {
        AbstractLocalDateAssert.assertLocalDateAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isAfter(LocalDate.parse(localDateTimeAsString));
    }

    public S isEqualTo(String dateTimeAsString) {
        AbstractLocalDateAssert.assertLocalDateAsStringParameterIsNotNull(dateTimeAsString);
        return (S)((AbstractLocalDateAssert)this.isEqualTo(LocalDate.parse(dateTimeAsString)));
    }

    public S isNotEqualTo(String dateTimeAsString) {
        AbstractLocalDateAssert.assertLocalDateAsStringParameterIsNotNull(dateTimeAsString);
        return (S)((AbstractLocalDateAssert)this.isNotEqualTo(LocalDate.parse(dateTimeAsString)));
    }

    public S isIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (S)((AbstractLocalDateAssert)this.isIn(AbstractLocalDateAssert.convertToLocalDateArray(dateTimesAsString)));
    }

    public S isNotIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (S)((AbstractLocalDateAssert)this.isNotIn(AbstractLocalDateAssert.convertToLocalDateArray(dateTimesAsString)));
    }

    private static Object[] convertToLocalDateArray(String ... dateTimesAsString) {
        Object[] dates = new LocalDate[dateTimesAsString.length];
        for (int i = 0; i < dateTimesAsString.length; ++i) {
            dates[i] = LocalDate.parse(dateTimesAsString[i]);
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The given LocalDate array should not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("The given LocalDate array should not be empty");
        }
    }

    private static void assertLocalDateAsStringParameterIsNotNull(String localDateTimeAsString) {
        if (localDateTimeAsString == null) {
            throw new IllegalArgumentException("The String representing the LocalDate to compare actual with should not be null");
        }
    }

    private static void assertLocalDateParameterIsNotNull(LocalDate other) {
        if (other == null) {
            throw new IllegalArgumentException(NULL_LOCAL_DATE_TIME_PARAMETER_MESSAGE);
        }
    }
}

