/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Closeables;
import org.assertj.core.util.FilesException;
import org.assertj.core.util.Flushables;
import org.assertj.core.util.Strings;

public class Files {
    public static List<String> fileNamesIn(String dirName, boolean recurse) {
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(String.format("%s is not a directory", Strings.quote(dirName)));
        }
        return Files.fileNamesIn(dir, recurse);
    }

    private static List<String> fileNamesIn(File dir, boolean recurse) {
        ArrayList<String> scriptNames = new ArrayList<String>();
        File[] existingFiles = dir.listFiles();
        if (Arrays.isNullOrEmpty(existingFiles)) {
            return scriptNames;
        }
        for (File existingFile : existingFiles) {
            if (existingFile.isDirectory()) {
                if (!recurse) continue;
                scriptNames.addAll(Files.fileNamesIn(existingFile, recurse));
                continue;
            }
            String filename = existingFile.getAbsolutePath();
            if (scriptNames.contains(filename)) continue;
            scriptNames.add(filename);
        }
        return scriptNames;
    }

    public static File temporaryFolder() {
        File temp = new File(Files.temporaryFolderPath());
        if (!temp.isDirectory()) {
            throw new FilesException("Unable to find temporary directory");
        }
        return temp;
    }

    public static String temporaryFolderPath() {
        return Strings.append(File.separator).to(System.getProperty("java.io.tmpdir"));
    }

    public static File newTemporaryFile() {
        String tempFileName = Strings.concat(String.valueOf(System.currentTimeMillis()), ".txt");
        return Files.newFile(Strings.concat(Files.temporaryFolderPath(), tempFileName));
    }

    public static File newTemporaryFolder() {
        String tempFileName = String.valueOf(System.currentTimeMillis());
        return Files.newFolder(Strings.concat(Files.temporaryFolderPath(), tempFileName));
    }

    public static File newFile(String path) {
        File file = new File(path);
        if (file.isDirectory() && !Arrays.isNullOrEmpty(file.list())) {
            throw Files.cannotCreateNewFile(path, "a non-empty directory was found with the same path");
        }
        try {
            if (!file.createNewFile()) {
                throw Files.cannotCreateNewFile(path, "a file was found with the same path");
            }
        }
        catch (IOException e) {
            throw Files.cannotCreateNewFile(path, e);
        }
        return file;
    }

    public static File newFolder(String path) {
        File file = new File(path);
        if (file.isDirectory() && !Arrays.isNullOrEmpty(file.list())) {
            throw Files.cannotCreateNewFile(path, "a non-empty directory was found with the same path");
        }
        try {
            if (!file.mkdir()) {
                throw Files.cannotCreateNewFile(path, "a file was found with the same path");
            }
        }
        catch (Exception e) {
            throw Files.cannotCreateNewFile(path, e);
        }
        return file;
    }

    private static FilesException cannotCreateNewFile(String path, String reason) {
        throw Files.cannotCreateNewFile(path, reason, null);
    }

    private static FilesException cannotCreateNewFile(String path, Exception cause) {
        throw Files.cannotCreateNewFile(path, null, cause);
    }

    private static FilesException cannotCreateNewFile(String path, String reason, Exception cause) {
        String message = String.format("Unable to create the new file %s", Strings.quote(path));
        if (!Strings.isNullOrEmpty(reason)) {
            message = Strings.concat(message, ": ", reason);
        }
        if (cause != null) {
            throw new FilesException(message, cause);
        }
        throw new FilesException(message);
    }

    public static void flushAndClose(Writer writer) {
        if (writer == null) {
            return;
        }
        Flushables.flush(writer);
        Closeables.closeQuietly(writer);
    }

    public static void flushAndClose(OutputStream out) {
        if (out == null) {
            return;
        }
        Flushables.flush(out);
        Closeables.closeQuietly(out);
    }

    public static File currentFolder() {
        try {
            return new File(".").getCanonicalFile();
        }
        catch (IOException e) {
            throw new FilesException("Unable to get current directory", e);
        }
    }

    public static void delete(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        for (File f : file.listFiles()) {
            Files.delete(f);
        }
        file.delete();
    }

    public static String contentOf(File file, String charsetName) {
        if (!Charset.isSupported(charsetName)) {
            throw new IllegalArgumentException(String.format("Charset:<'%s'> is not supported on this system", charsetName));
        }
        return Files.contentOf(file, Charset.forName(charsetName));
    }

    public static String contentOf(File file, Charset charset) {
        if (charset == null) {
            throw new NullPointerException("The charset should not be null");
        }
        try {
            return Files.loadContents(file, charset);
        }
        catch (IOException e) {
            throw new FilesException("Unable to read " + file.getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadContents(File file, Charset charset) throws IOException {
        BufferedReader reader = null;
        boolean threw = true;
        try {
            int c;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
            StringWriter writer = new StringWriter();
            while ((c = reader.read()) != -1) {
                writer.write(c);
            }
            threw = false;
            String string = writer.toString();
            return string;
        }
        finally {
            block9: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        if (threw) break block9;
                        throw e;
                    }
                }
            }
        }
    }

    private Files() {
    }
}

