/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeBetween;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldBeGreater;
import org.assertj.core.error.ShouldBeGreaterOrEqual;
import org.assertj.core.error.ShouldBeLess;
import org.assertj.core.error.ShouldBeLessOrEqual;
import org.assertj.core.error.ShouldNotBeEqual;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public class Comparables {
    private static final Comparables INSTANCE = new Comparables();
    @VisibleForTesting
    Failures failures = Failures.instance();
    ComparisonStrategy comparisonStrategy;

    public static Comparables instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Comparables() {
        this(StandardComparisonStrategy.instance());
    }

    public Comparables(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    @VisibleForTesting
    void setFailures(Failures failures) {
        this.failures = failures;
    }

    @VisibleForTesting
    void resetFailures() {
        this.failures = Failures.instance();
    }

    public <T> void assertEqual(AssertionInfo info, T actual, T expected) {
        Comparables.assertNotNull(info, actual);
        if (this.areEqual(actual, expected)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, expected, this.comparisonStrategy));
    }

    protected <T> boolean areEqual(T actual, T expected) {
        return this.comparisonStrategy.areEqual(actual, expected);
    }

    public <T> void assertNotEqual(AssertionInfo info, T actual, T other) {
        Comparables.assertNotNull(info, actual);
        if (!this.areEqual(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEqual.shouldNotBeEqual(actual, other, this.comparisonStrategy));
    }

    public <T extends Comparable<? super T>> void assertEqualByComparison(AssertionInfo info, T actual, T expected) {
        Comparables.assertNotNull(info, actual);
        if (actual.compareTo(expected) == 0) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, expected));
    }

    public <T extends Comparable<? super T>> void assertNotEqualByComparison(AssertionInfo info, T actual, T other) {
        Comparables.assertNotNull(info, actual);
        if (actual.compareTo(other) != 0) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEqual.shouldNotBeEqual(actual, other));
    }

    public <T extends Comparable<? super T>> void assertLessThan(AssertionInfo info, T actual, T other) {
        Comparables.assertNotNull(info, actual);
        if (this.isLessThan(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeLess.shouldBeLess(actual, other, this.comparisonStrategy));
    }

    public <T extends Comparable<? super T>> void assertLessThanOrEqualTo(AssertionInfo info, T actual, T other) {
        Comparables.assertNotNull(info, actual);
        if (!this.isGreaterThan(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeLessOrEqual.shouldBeLessOrEqual(actual, other, this.comparisonStrategy));
    }

    public <T extends Comparable<? super T>> void assertGreaterThan(AssertionInfo info, T actual, T other) {
        Comparables.assertNotNull(info, actual);
        if (this.isGreaterThan(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeGreater.shouldBeGreater(actual, other, this.comparisonStrategy));
    }

    private boolean isGreaterThan(Object actual, Object other) {
        return this.comparisonStrategy.isGreaterThan(actual, other);
    }

    public <T extends Comparable<? super T>> void assertGreaterThanOrEqualTo(AssertionInfo info, T actual, T other) {
        Comparables.assertNotNull(info, actual);
        if (!this.isLessThan(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeGreaterOrEqual.shouldBeGreaterOrEqual(actual, other, this.comparisonStrategy));
    }

    private boolean isLessThan(Object actual, Object other) {
        return this.comparisonStrategy.isLessThan(actual, other);
    }

    protected static <T> void assertNotNull(AssertionInfo info, T actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    public <T extends Comparable<? super T>> void assertIsBetween(AssertionInfo info, T actual, T start, T end, boolean inclusiveStart, boolean inclusiveEnd) {
        boolean checkUpperBoundaryRange;
        boolean checkLowerBoundaryRange;
        Comparables.assertNotNull(info, actual);
        Comparables.startParameterIsNotNull(start);
        Comparables.endParameterIsNotNull(end);
        boolean bl = inclusiveStart ? !this.isGreaterThan(start, actual) : (checkLowerBoundaryRange = this.isLessThan(start, actual));
        boolean bl2 = inclusiveEnd ? !this.isGreaterThan(actual, end) : (checkUpperBoundaryRange = this.isLessThan(actual, end));
        if (checkLowerBoundaryRange && checkUpperBoundaryRange) {
            return;
        }
        throw this.failures.failure(info, ShouldBeBetween.shouldBeBetween(actual, start, end, inclusiveStart, inclusiveEnd, this.comparisonStrategy));
    }

    private static void startParameterIsNotNull(Object start) {
        if (start == null) {
            throw new NullPointerException("The start range to compare actual with should not be null");
        }
    }

    private static void endParameterIsNotNull(Object end) {
        if (end == null) {
            throw new NullPointerException("The end range to compare actual with should not be null");
        }
    }
}

