/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.groups;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.PropertySupport;
import org.assertj.core.util.Lists;
import org.assertj.core.util.introspection.FieldSupport;
import org.assertj.core.util.introspection.IntrospectionError;

public class FieldsOrPropertiesExtractor {
    public static Object[] extract(String fieldOrPropertyName, Object[] objects) {
        ArrayList<Object> newArrayList = Lists.newArrayList(objects);
        List<Object> extractedValues = FieldsOrPropertiesExtractor.extract(fieldOrPropertyName, newArrayList);
        return extractedValues.toArray();
    }

    public static Tuple[] extract(Object[] objects, String ... fieldsOrPropertiesNames) {
        ArrayList<Object> newArrayList = Lists.newArrayList(objects);
        List<Tuple> extractedValues = FieldsOrPropertiesExtractor.extract(newArrayList, fieldsOrPropertiesNames);
        return extractedValues.toArray(new Tuple[0]);
    }

    public static List<Object> extract(String propertyOrFieldName, Iterable<?> objects) {
        if (propertyOrFieldName == null) {
            throw new IllegalArgumentException("The name of the field/property to read should not be null");
        }
        if (propertyOrFieldName.length() == 0) {
            throw new IllegalArgumentException("The name of the field/property to read should not be empty");
        }
        if (objects == null) {
            throw new IllegalArgumentException("The objects to extract field/property from should not be null");
        }
        try {
            return PropertySupport.instance().propertyValues(propertyOrFieldName, objects);
        }
        catch (IntrospectionError fieldIntrospectionError) {
            try {
                return FieldSupport.instance().fieldValues(propertyOrFieldName, objects);
            }
            catch (IntrospectionError propertyIntrospectionError) {
                String message = String.format("\nCan't find any field or property with name '%s'.\nError when introspecting fields was :\n- %s \nError when introspecting properties was :\n- %s", propertyOrFieldName, fieldIntrospectionError.getMessage(), propertyIntrospectionError.getMessage());
                throw new IntrospectionError(message);
            }
        }
    }

    public static List<Tuple> extract(Iterable<?> objects, String ... fieldsOrPropertiesNames) {
        if (fieldsOrPropertiesNames == null) {
            throw new IllegalArgumentException("The names of the fields/properties to read should not be null");
        }
        if (fieldsOrPropertiesNames.length == 0) {
            throw new IllegalArgumentException("The names of the fields/properties to read should not be empty");
        }
        if (objects == null) {
            throw new IllegalArgumentException("The objects to extract fields/properties from should not be null");
        }
        ArrayList<?> objectsAsList = Lists.newArrayList(objects);
        List<Tuple> extractedTuples = Tuple.buildTuples(objectsAsList.size());
        for (String fieldOrPropertyName : fieldsOrPropertiesNames) {
            List<Object> extractValues = FieldsOrPropertiesExtractor.extract(fieldOrPropertyName, objectsAsList);
            for (int i = 0; i < objectsAsList.size(); ++i) {
                extractedTuples.get(i).addData(extractValues.get(i));
            }
        }
        return extractedTuples;
    }
}

