/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ArraySortedAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.DoubleArrays;
import org.assertj.core.util.VisibleForTesting;

public class DoubleArrayAssert
extends AbstractAssert<DoubleArrayAssert, double[]>
implements EnumerableAssert<DoubleArrayAssert, Double>,
ArraySortedAssert<DoubleArrayAssert, Double> {
    @VisibleForTesting
    DoubleArrays arrays = DoubleArrays.instance();

    protected DoubleArrayAssert(double[] actual) {
        super(actual, DoubleArrayAssert.class);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (double[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (double[])this.actual);
    }

    @Override
    public DoubleArrayAssert isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (double[])this.actual);
        return this;
    }

    @Override
    public DoubleArrayAssert hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (double[])this.actual, expected);
        return this;
    }

    @Override
    public DoubleArrayAssert hasSameSizeAs(Object[] other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (double[])this.actual, other);
        return this;
    }

    @Override
    public DoubleArrayAssert hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (double[])this.actual, other);
        return this;
    }

    public DoubleArrayAssert contains(double ... values) {
        this.arrays.assertContains(this.info, (double[])this.actual, values);
        return this;
    }

    public DoubleArrayAssert containsOnly(double ... values) {
        this.arrays.assertContainsOnly(this.info, (double[])this.actual, values);
        return this;
    }

    public DoubleArrayAssert containsSequence(double ... sequence) {
        this.arrays.assertContainsSequence(this.info, (double[])this.actual, sequence);
        return this;
    }

    public DoubleArrayAssert contains(double value, Index index) {
        this.arrays.assertContains(this.info, (double[])this.actual, value, index);
        return this;
    }

    public DoubleArrayAssert doesNotContain(double ... values) {
        this.arrays.assertDoesNotContain(this.info, (double[])this.actual, values);
        return this;
    }

    public DoubleArrayAssert doesNotContain(double value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (double[])this.actual, value, index);
        return this;
    }

    public DoubleArrayAssert doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (double[])this.actual);
        return this;
    }

    public DoubleArrayAssert startsWith(double ... sequence) {
        this.arrays.assertStartsWith(this.info, (double[])this.actual, sequence);
        return this;
    }

    public DoubleArrayAssert endsWith(double ... sequence) {
        this.arrays.assertEndsWith(this.info, (double[])this.actual, sequence);
        return this;
    }

    @Override
    public DoubleArrayAssert isSorted() {
        this.arrays.assertIsSorted(this.info, (double[])this.actual);
        return this;
    }

    @Override
    public DoubleArrayAssert isSortedAccordingTo(Comparator<? super Double> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (double[])this.actual, comparator);
        return this;
    }

    @Override
    public DoubleArrayAssert usingElementComparator(Comparator<? super Double> customComparator) {
        this.arrays = new DoubleArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (DoubleArrayAssert)this.myself;
    }

    @Override
    public DoubleArrayAssert usingDefaultElementComparator() {
        this.arrays = DoubleArrays.instance();
        return (DoubleArrayAssert)this.myself;
    }
}

