/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.internal.Bytes;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public class ByteAssert
extends AbstractComparableAssert<ByteAssert, Byte>
implements NumberAssert<Byte> {
    @VisibleForTesting
    Bytes bytes = Bytes.instance();

    protected ByteAssert(Byte actual) {
        super(actual, ByteAssert.class);
    }

    @Override
    public ByteAssert isEqualTo(byte expected) {
        this.bytes.assertEqual(this.info, this.actual, expected);
        return this;
    }

    @Override
    public ByteAssert isNotEqualTo(byte other) {
        this.bytes.assertNotEqual(this.info, this.actual, other);
        return this;
    }

    public ByteAssert isZero() {
        this.bytes.assertIsZero(this.info, (Comparable)this.actual);
        return this;
    }

    public ByteAssert isNotZero() {
        this.bytes.assertIsNotZero(this.info, (Comparable)this.actual);
        return this;
    }

    public ByteAssert isPositive() {
        this.bytes.assertIsPositive(this.info, (Comparable)this.actual);
        return this;
    }

    public ByteAssert isNegative() {
        this.bytes.assertIsNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public ByteAssert isNotNegative() {
        this.bytes.assertIsNotNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public ByteAssert isNotPositive() {
        this.bytes.assertIsNotPositive(this.info, (Comparable)this.actual);
        return this;
    }

    @Override
    public ByteAssert isLessThan(byte other) {
        this.bytes.assertLessThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public ByteAssert isLessThanOrEqualTo(byte other) {
        this.bytes.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public ByteAssert isGreaterThan(byte other) {
        this.bytes.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public ByteAssert isGreaterThanOrEqualTo(byte other) {
        this.bytes.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    public ByteAssert isBetween(Byte start, Byte end) {
        this.bytes.assertIsBetween(this.info, (Comparable)this.actual, start, end);
        return this;
    }

    public ByteAssert isStrictlyBetween(Byte start, Byte end) {
        this.bytes.assertIsStrictlyBetween(this.info, (Comparable)this.actual, start, end);
        return this;
    }

    @Override
    public ByteAssert usingComparator(Comparator<? super Byte> customComparator) {
        super.usingComparator(customComparator);
        this.bytes = new Bytes(new ComparatorBasedComparisonStrategy(customComparator));
        return (ByteAssert)this.myself;
    }

    @Override
    public ByteAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.bytes = Bytes.instance();
        return (ByteAssert)this.myself;
    }
}

