/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ArraySortedAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ByteArrays;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public class ByteArrayAssert
extends AbstractAssert<ByteArrayAssert, byte[]>
implements EnumerableAssert<ByteArrayAssert, Byte>,
ArraySortedAssert<ByteArrayAssert, Byte> {
    @VisibleForTesting
    ByteArrays arrays = ByteArrays.instance();

    protected ByteArrayAssert(byte[] actual) {
        super(actual, ByteArrayAssert.class);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (byte[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (byte[])this.actual);
    }

    @Override
    public ByteArrayAssert isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (byte[])this.actual);
        return this;
    }

    @Override
    public ByteArrayAssert hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (byte[])this.actual, expected);
        return this;
    }

    @Override
    public ByteArrayAssert hasSameSizeAs(Object[] other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (byte[])this.actual, other);
        return this;
    }

    @Override
    public ByteArrayAssert hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (byte[])this.actual, other);
        return this;
    }

    public ByteArrayAssert contains(byte ... values) {
        this.arrays.assertContains(this.info, (byte[])this.actual, values);
        return this;
    }

    public ByteArrayAssert containsOnly(byte ... values) {
        this.arrays.assertContainsOnly(this.info, (byte[])this.actual, values);
        return this;
    }

    public ByteArrayAssert containsSequence(byte ... sequence) {
        this.arrays.assertContainsSequence(this.info, (byte[])this.actual, sequence);
        return this;
    }

    public ByteArrayAssert contains(byte value, Index index) {
        this.arrays.assertContains(this.info, (byte[])this.actual, value, index);
        return this;
    }

    public ByteArrayAssert doesNotContain(byte ... values) {
        this.arrays.assertDoesNotContain(this.info, (byte[])this.actual, values);
        return this;
    }

    public ByteArrayAssert doesNotContain(byte value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (byte[])this.actual, value, index);
        return this;
    }

    public ByteArrayAssert doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (byte[])this.actual);
        return this;
    }

    public ByteArrayAssert startsWith(byte ... sequence) {
        this.arrays.assertStartsWith(this.info, (byte[])this.actual, sequence);
        return this;
    }

    public ByteArrayAssert endsWith(byte ... sequence) {
        this.arrays.assertEndsWith(this.info, (byte[])this.actual, sequence);
        return this;
    }

    @Override
    public ByteArrayAssert isSorted() {
        this.arrays.assertIsSorted(this.info, (byte[])this.actual);
        return this;
    }

    @Override
    public ByteArrayAssert isSortedAccordingTo(Comparator<? super Byte> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (byte[])this.actual, comparator);
        return this;
    }

    @Override
    public ByteArrayAssert usingElementComparator(Comparator<? super Byte> customComparator) {
        this.arrays = new ByteArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (ByteArrayAssert)this.myself;
    }

    @Override
    public ByteArrayAssert usingDefaultElementComparator() {
        this.arrays = ByteArrays.instance();
        return (ByteArrayAssert)this.myself;
    }
}

