/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Booleans;
import org.assertj.core.util.VisibleForTesting;

public class BooleanAssert
extends AbstractAssert<BooleanAssert, Boolean> {
    @VisibleForTesting
    Booleans booleans = Booleans.instance();

    protected BooleanAssert(Boolean actual) {
        super(actual, BooleanAssert.class);
    }

    public BooleanAssert isTrue() {
        return this.isEqualTo(true);
    }

    public BooleanAssert isFalse() {
        return this.isEqualTo(false);
    }

    @Override
    public BooleanAssert isEqualTo(boolean expected) {
        this.booleans.assertEqual(this.info, (Boolean)this.actual, expected);
        return this;
    }

    @Override
    public BooleanAssert isNotEqualTo(boolean other) {
        this.booleans.assertNotEqual(this.info, (Boolean)this.actual, other);
        return this;
    }

    @Override
    @Deprecated
    public final BooleanAssert usingComparator(Comparator<? super Boolean> customComparator) {
        throw new UnsupportedOperationException("custom Comparator is not supported for Boolean comparison");
    }
}

