/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.IconRegistry;
import org.aspectj.ajde.ui.FileStructureView;
import org.aspectj.ajde.ui.InvalidResourceException;
import org.aspectj.ajde.ui.UserPreferencesAdapter;
import org.aspectj.ajde.ui.internal.UserPreferencesStore;
import org.aspectj.ajde.ui.javaoptions.JavaBuildOptions;
import org.aspectj.ajde.ui.javaoptions.JavaCompilerWarningsOptionsPanel;
import org.aspectj.ajde.ui.javaoptions.JavaComplianceOptionsPanel;
import org.aspectj.ajde.ui.javaoptions.JavaDebugOptionsPanel;
import org.aspectj.ajde.ui.javaoptions.JavaOtherOptionsPanel;
import org.aspectj.ajde.ui.swing.MultiStructureViewPanel;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IHierarchyListener;
import org.aspectj.tools.ajbrowser.core.BrowserBuildProgressMonitor;
import org.aspectj.tools.ajbrowser.core.BrowserCompilerConfiguration;
import org.aspectj.tools.ajbrowser.core.BrowserErrorHandler;
import org.aspectj.tools.ajbrowser.ui.BasicEditor;
import org.aspectj.tools.ajbrowser.ui.BrowserMessageHandler;
import org.aspectj.tools.ajbrowser.ui.BrowserRuntimeProperties;
import org.aspectj.tools.ajbrowser.ui.BrowserUIAdapter;
import org.aspectj.tools.ajbrowser.ui.EditorManager;
import org.aspectj.tools.ajbrowser.ui.swing.BrowserOptionsPanel;
import org.aspectj.tools.ajbrowser.ui.swing.MessageHandlerPanel;
import org.aspectj.tools.ajbrowser.ui.swing.TopFrame;
import org.aspectj.util.FileUtil;

public class BrowserManager {
    public static final String TITLE = "AspectJ Browser";
    private static final BrowserManager INSTANCE = new BrowserManager();
    private EditorManager editorManager;
    private UserPreferencesAdapter preferencesAdapter;
    private static TopFrame topFrame = null;
    private List<String> configFiles = new ArrayList<String>();
    private JavaBuildOptions javaBuildOptions;
    public final IHierarchyListener VIEW_LISTENER = new IHierarchyListener(){

        @Override
        public void elementsUpdated(IHierarchy model) {
            FileStructureView fsv = Ajde.getDefault().getStructureViewManager().getDefaultFileView();
            if (fsv != null) {
                fsv.setSourceFile(BrowserManager.getDefault().getEditorManager().getCurrFile());
            }
        }
    };

    public static BrowserManager getDefault() {
        return INSTANCE;
    }

    public void init(String[] configFilesArgs, boolean visible) {
        try {
            this.javaBuildOptions = new JavaBuildOptions();
            this.preferencesAdapter = new UserPreferencesStore(true);
            topFrame = new TopFrame();
            BasicEditor ajdeEditor = new BasicEditor();
            this.editorManager = new EditorManager(ajdeEditor);
            BrowserMessageHandler messageHandler = new BrowserMessageHandler();
            Ajde.getDefault().init(new BrowserCompilerConfiguration(this.preferencesAdapter), messageHandler, new BrowserBuildProgressMonitor(messageHandler), ajdeEditor, new BrowserUIAdapter(), new IconRegistry(), topFrame, new BrowserRuntimeProperties(this.preferencesAdapter), true);
            this.setUpTopFrame(visible);
            this.addOptionsPanels();
            this.setUpConfigFiles(configFilesArgs);
            Ajde.getDefault().getModel().addListener(this.VIEW_LISTENER);
        }
        catch (Throwable t) {
            t.printStackTrace();
            BrowserErrorHandler.handleError("AJDE failed to initialize.", t);
        }
    }

    private void setUpConfigFiles(String[] configFilesArgs) {
        this.configFiles = this.getConfigFilesList(configFilesArgs);
        if (this.configFiles.size() == 0) {
            BrowserErrorHandler.handleWarning("No build configuration selected. Select a \".lst\" build configuration file in order to compile and navigate structure.");
        } else {
            Ajde.getDefault().getBuildConfigManager().setActiveConfigFile(this.configFiles.get(0));
        }
    }

    private void setUpTopFrame(boolean visible) {
        MultiStructureViewPanel multiViewPanel = new MultiStructureViewPanel(Ajde.getDefault().getViewManager().getBrowserPanel(), Ajde.getDefault().getFileStructurePanel());
        topFrame.init(multiViewPanel, new MessageHandlerPanel(), this.editorManager.getEditorPanel());
        if (visible) {
            topFrame.setVisible(true);
        }
    }

    public void resetEditorFrame() {
        topFrame.resetSourceEditorPanel();
    }

    public void resetEditor() {
        BrowserManager.getDefault().getRootFrame().setSize(BrowserManager.getDefault().getRootFrame().getWidth() + 1, BrowserManager.getDefault().getRootFrame().getHeight() + 1);
        BrowserManager.getDefault().getRootFrame().doLayout();
        BrowserManager.getDefault().getRootFrame().repaint();
    }

    public void setStatusInformation(String text) {
        BrowserManager.topFrame.statusText_label.setText(text);
    }

    public void setEditorStatusText(String text) {
        topFrame.setTitle("AspectJ Browser - " + text);
    }

    public void saveAll() {
        this.editorManager.saveContents();
    }

    public JFrame getRootFrame() {
        return topFrame;
    }

    public void openFile(String filePath) {
        try {
            if (filePath.endsWith(".lst")) {
                Ajde.getDefault().getBuildConfigEditor().openFile(filePath);
                topFrame.setEditorPanel(Ajde.getDefault().getBuildConfigEditor());
            } else if (FileUtil.hasSourceSuffix(filePath)) {
                this.editorManager.showSourceLine(filePath, 0, false);
            } else {
                BrowserErrorHandler.handleError("File: " + filePath + " could not be opened because the extension was not recoginzed.");
            }
        }
        catch (IOException ioe) {
            BrowserErrorHandler.handleError("Could not open file: " + filePath, ioe);
        }
        catch (InvalidResourceException ire) {
            BrowserErrorHandler.handleError("Invalid file: " + filePath, ire);
        }
    }

    private List<String> getConfigFilesList(String[] configFiles) {
        ArrayList<String> configs = new ArrayList<String>();
        for (int i = 0; i < configFiles.length; ++i) {
            if (!configFiles[i].endsWith(".lst")) continue;
            configs.add(configFiles[i]);
        }
        return configs;
    }

    private void addOptionsPanels() {
        Ajde.getDefault().getOptionsFrame().addOptionsPanel(new JavaComplianceOptionsPanel(this.javaBuildOptions));
        Ajde.getDefault().getOptionsFrame().addOptionsPanel(new JavaCompilerWarningsOptionsPanel(this.javaBuildOptions));
        Ajde.getDefault().getOptionsFrame().addOptionsPanel(new JavaOtherOptionsPanel(this.javaBuildOptions));
        Ajde.getDefault().getOptionsFrame().addOptionsPanel(new JavaDebugOptionsPanel(this.javaBuildOptions));
        Ajde.getDefault().getOptionsFrame().addOptionsPanel(new BrowserOptionsPanel());
    }

    public EditorManager getEditorManager() {
        return this.editorManager;
    }

    public UserPreferencesAdapter getPreferencesAdapter() {
        return this.preferencesAdapter;
    }

    public JavaBuildOptions getJavaBuildOptions() {
        return this.javaBuildOptions;
    }
}

