/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.field;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.org.eclipse.jdt.internal.core.nd.IDestructable;
import org.aspectj.org.eclipse.jdt.internal.core.nd.ITypeFactory;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Database;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.ModificationLog;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.Field;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldByte;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldChar;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldDouble;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldFloat;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldInt;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldLong;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldPointer;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldShort;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IDestructableField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IRefCountedField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.util.MathUtils;

public final class StructDef<T> {
    Class<T> clazz;
    private StructDef<? super T> superClass;
    private Set<StructDef<?>> dependencies = new HashSet();
    private List<IField> fields = new ArrayList<IField>();
    private boolean doneCalled;
    private boolean offsetsComputed;
    private List<StructDef<? extends T>> dependents = new ArrayList<StructDef<? extends T>>();
    private int size;
    List<IDestructableField> destructableFields = new ArrayList<IDestructableField>();
    boolean refCounted;
    private List<IRefCountedField> refCountedFields = new ArrayList<IRefCountedField>();
    private List<IRefCountedField> ownerFields = new ArrayList<IRefCountedField>();
    boolean isAbstract;
    private ITypeFactory<T> factory;
    protected boolean hasUserDestructor;
    private DeletionSemantics deletionSemantics;
    final ModificationLog.Tag destructTag;
    private boolean isNdNode;

    private StructDef(Class<T> clazz) {
        this(clazz, null);
    }

    private StructDef(Class<T> clazz, StructDef<? super T> superClass) {
        this(clazz, superClass, Modifier.isAbstract(clazz.getModifiers()));
    }

    private StructDef(Class<T> clazz, StructDef<? super T> superClass, boolean isAbstract) {
        Constructor<T> constructor;
        this.destructTag = ModificationLog.createTag("Destructing struct " + clazz.getSimpleName());
        this.clazz = clazz;
        this.isNdNode = NdNode.class.isAssignableFrom(clazz);
        this.superClass = superClass;
        if (this.superClass != null) {
            this.addDependency(this.superClass);
        }
        this.isAbstract = isAbstract;
        final String fullyQualifiedClassName = clazz.getName();
        if (!this.isAbstract) {
            try {
                constructor = clazz.getConstructor(Nd.class, Long.TYPE);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalArgumentException("The node class " + fullyQualifiedClassName + " does not have an appropriate constructor for it to be used with Nd");
            }
        } else {
            constructor = null;
        }
        this.hasUserDestructor = IDestructable.class.isAssignableFrom(clazz);
        this.factory = new ITypeFactory<T>(){

            @Override
            public T create(Nd dom, long address) {
                if (StructDef.this.isAbstract) {
                    throw new UnsupportedOperationException("Attempting to instantiate abstract class" + fullyQualifiedClassName);
                }
                try {
                    return constructor.newInstance(dom, address);
                }
                catch (InvocationTargetException e) {
                    Throwable target = e.getCause();
                    if (target instanceof RuntimeException) {
                        throw (RuntimeException)target;
                    }
                    throw new RuntimeException("Error in AutoTypeFactory", e);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Error in AutoTypeFactory", e);
                }
            }

            @Override
            public int getRecordSize() {
                return StructDef.this.size();
            }

            @Override
            public boolean hasDestructor() {
                return StructDef.this.hasUserDestructor || StructDef.this.hasDestructableFields();
            }

            @Override
            public Class<?> getElementClass() {
                return StructDef.this.clazz;
            }

            @Override
            public void destruct(Nd nd, long address) {
                StructDef.this.checkNotMutable();
                Database db = nd.getDB();
                db.getLog().start(StructDef.this.destructTag);
                try {
                    if (StructDef.this.hasUserDestructor) {
                        IDestructable destructable = (IDestructable)this.create(nd, address);
                        destructable.destruct();
                    }
                    this.destructFields(nd, address);
                }
                finally {
                    db.getLog().end(StructDef.this.destructTag);
                }
            }

            @Override
            public void destructFields(Nd dom, long address) {
                StructDef.this.destructFields(dom, address);
            }

            @Override
            public boolean isReadyForDeletion(Nd dom, long address) {
                return StructDef.this.isReadyForDeletion(dom, address);
            }

            @Override
            public DeletionSemantics getDeletionSemantics() {
                return StructDef.this.getDeletionSemantics();
            }
        };
    }

    public void addDependency(StructDef<?> newDependency) {
        if (super.hasIndirectDependent(new HashSet(), this)) {
            throw new IllegalArgumentException("Circular dependency detected. Struct " + this.getStructName() + " and struct " + newDependency.getStructName() + " both depend on one another");
        }
        if (this.dependencies.add(newDependency)) {
            this.superClass.dependents.add(this);
        }
    }

    private boolean hasIndirectDependent(Set<StructDef<?>> visited, StructDef<?> structDef) {
        for (StructDef<T> next : this.dependents) {
            if (!visited.add(next)) continue;
            if (next.equals(structDef)) {
                return true;
            }
            if (!super.hasIndirectDependent(visited, structDef)) continue;
            return true;
        }
        return false;
    }

    public Class<T> getStructClass() {
        return this.clazz;
    }

    public String toString() {
        return this.clazz.getName();
    }

    public static <T> StructDef<T> createAbstract(Class<T> clazz) {
        return new StructDef<T>(clazz, null, true);
    }

    public static <T> StructDef<T> createAbstract(Class<T> clazz, StructDef<? super T> superClass) {
        return new StructDef<T>(clazz, superClass, true);
    }

    public static <T> StructDef<T> create(Class<T> clazz) {
        return new StructDef<T>(clazz);
    }

    public static <T> StructDef<T> create(Class<T> clazz, StructDef<? super T> superClass) {
        return new StructDef<T>(clazz, superClass);
    }

    protected boolean isReadyForDeletion(Nd dom, long address) {
        List<IRefCountedField> toIterate = Collections.EMPTY_LIST;
        switch (this.deletionSemantics) {
            case EXPLICIT: {
                return false;
            }
            case OWNED: {
                toIterate = this.ownerFields;
                break;
            }
            case REFCOUNTED: {
                toIterate = this.refCountedFields;
            }
        }
        for (IRefCountedField next : toIterate) {
            if (!next.hasReferences(dom, address)) continue;
            return false;
        }
        StructDef<T> localSuperClass = this.superClass;
        if (localSuperClass != null && localSuperClass.deletionSemantics != DeletionSemantics.EXPLICIT) {
            return localSuperClass.isReadyForDeletion(dom, address);
        }
        return true;
    }

    protected boolean hasDestructableFields() {
        return !this.destructableFields.isEmpty() || this.superClass != null && this.superClass.hasDestructableFields();
    }

    public DeletionSemantics getDeletionSemantics() {
        return this.deletionSemantics;
    }

    private boolean areAllDependenciesResolved() {
        for (StructDef<?> next : this.dependencies) {
            if (next.areOffsetsComputed()) continue;
            return false;
        }
        return true;
    }

    public void done() {
        if (this.doneCalled) {
            throw new IllegalStateException("May not call done() more than once");
        }
        this.doneCalled = true;
        if (this.areAllDependenciesResolved()) {
            this.computeOffsets();
        }
    }

    public void add(IField toAdd) {
        this.checkMutable();
        this.fields.add(toAdd);
    }

    public void addDestructableField(IDestructableField field) {
        this.checkMutable();
        this.destructableFields.add(field);
    }

    public StructDef<T> useStandardRefCounting() {
        this.checkMutable();
        this.refCounted = true;
        return this;
    }

    public void addRefCountedField(IRefCountedField result) {
        this.checkMutable();
        this.refCountedFields.add(result);
    }

    public void addOwnerField(IRefCountedField result) {
        this.checkMutable();
        this.ownerFields.add(result);
    }

    public boolean areOffsetsComputed() {
        return this.offsetsComputed;
    }

    public int size() {
        this.checkNotMutable();
        return this.size;
    }

    void checkNotMutable() {
        if (!this.offsetsComputed) {
            throw new IllegalStateException("Must call done() before using the struct");
        }
    }

    private void checkMutable() {
        if (this.doneCalled) {
            throw new IllegalStateException("May not modify a StructDef after done() has been called");
        }
    }

    private void computeOffsets() {
        int offset = this.superClass == null ? 0 : this.superClass.size();
        for (IField iField : this.fields) {
            offset = MathUtils.roundUpToNearestMultiple(offset, iField.getAlignment());
            iField.setOffset(offset);
            offset += iField.getRecordSize();
        }
        this.size = offset;
        this.deletionSemantics = this.refCounted ? DeletionSemantics.REFCOUNTED : (!this.ownerFields.isEmpty() ? DeletionSemantics.OWNED : (this.superClass != null ? this.superClass.deletionSemantics : DeletionSemantics.EXPLICIT));
        if (this.superClass != null && this.deletionSemantics != this.superClass.deletionSemantics && this.superClass.deletionSemantics != DeletionSemantics.EXPLICIT) {
            throw new IllegalStateException("A class (" + this.clazz.getName() + ") that uses " + this.deletionSemantics.toString() + " deletion semantics may not inherit from a class " + "that uses " + this.superClass.deletionSemantics.toString() + " semantics");
        }
        this.offsetsComputed = true;
        for (StructDef structDef : this.dependents) {
            if (!structDef.doneCalled) continue;
            structDef.computeOffsets();
        }
    }

    public FieldPointer addPointer() {
        FieldPointer result = new FieldPointer(this.getStructName(), this.fields.size());
        this.add(result);
        return result;
    }

    public FieldShort addShort() {
        FieldShort result = new FieldShort(this.getStructName(), this.fields.size());
        this.add(result);
        return result;
    }

    public FieldInt addInt() {
        FieldInt result = new FieldInt(this.getStructName(), this.fields.size());
        this.add(result);
        return result;
    }

    public FieldLong addLong() {
        FieldLong result = new FieldLong(this.getStructName(), this.fields.size());
        this.add(result);
        return result;
    }

    public FieldString addString() {
        FieldString result = new FieldString(this.getStructName(), this.fields.size());
        this.add(result);
        this.addDestructableField(result);
        return result;
    }

    public FieldDouble addDouble() {
        FieldDouble result = new FieldDouble(this.getStructName(), this.fields.size());
        this.add(result);
        return result;
    }

    public FieldFloat addFloat() {
        FieldFloat result = new FieldFloat(this.getStructName(), this.fields.size());
        this.add(result);
        return result;
    }

    public String getStructName() {
        return this.clazz.getSimpleName();
    }

    public FieldByte addByte() {
        FieldByte result = new FieldByte(this.getStructName(), this.fields.size());
        this.add(result);
        return result;
    }

    public FieldChar addChar() {
        FieldChar result = new FieldChar(this.getStructName(), this.fields.size());
        this.add(result);
        return result;
    }

    public <F> Field<F> add(ITypeFactory<F> factory1) {
        Field<F> result = new Field<F>(factory1, this.getStructName(), this.fields.size());
        this.add(result);
        if (result.factory.hasDestructor()) {
            this.destructableFields.add(result);
        }
        return result;
    }

    public ITypeFactory<T> getFactory() {
        return this.factory;
    }

    void destructFields(Nd dom, long address) {
        for (IDestructableField next : this.destructableFields) {
            next.destruct(dom, address);
        }
        if (this.superClass != null) {
            this.superClass.destructFields(dom, address);
        }
    }

    public boolean isNdNode() {
        return this.isNdNode;
    }

    public int getNumFields() {
        return this.fields.size();
    }

    public static enum DeletionSemantics {
        EXPLICIT,
        OWNED,
        REFCOUNTED;

    }
}

