/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.UserPreferencesAdapter;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;
import org.aspectj.util.LangUtil;

public class UserPreferencesStore
implements UserPreferencesAdapter {
    public static final String FILE_NAME = "/.ajbrowser";
    private static final String VALUE_SEP = ";";
    private Properties properties = new Properties();
    private boolean persist = true;

    public UserPreferencesStore() {
        this(true);
    }

    public UserPreferencesStore(boolean loadDefault) {
        this.persist = loadDefault;
        if (this.persist) {
            this.loadProperties(UserPreferencesStore.getPropertiesFilePath());
        }
    }

    @Override
    public String getProjectPreference(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public List getProjectMultivalPreference(String name) {
        ArrayList<String> values = new ArrayList<String>();
        String valuesString = this.properties.getProperty(name);
        if (valuesString != null && !valuesString.trim().equals("")) {
            StringTokenizer st = new StringTokenizer(valuesString, VALUE_SEP);
            while (st.hasMoreTokens()) {
                values.add(st.nextToken());
            }
        }
        return values;
    }

    @Override
    public void setProjectPreference(String name, String value) {
        this.properties.setProperty(name, value);
        this.saveProperties();
    }

    @Override
    public void setProjectMultivalPreference(String name, List values) {
        String valuesString = "";
        Iterator it = values.iterator();
        while (it.hasNext()) {
            valuesString = valuesString + (String)it.next() + ';';
        }
        this.properties.setProperty(name, valuesString);
        this.saveProperties();
    }

    public static String getPropertiesFilePath() {
        String path = System.getProperty("user.home");
        if (path == null) {
            path = ".";
        }
        return path + FILE_NAME;
    }

    @Override
    public String getGlobalPreference(String name) {
        return this.getProjectPreference(name);
    }

    @Override
    public List getGlobalMultivalPreference(String name) {
        return this.getProjectMultivalPreference(name);
    }

    @Override
    public void setGlobalPreference(String name, String value) {
        this.setProjectPreference(name, value);
    }

    @Override
    public void setGlobalMultivalPreference(String name, List values) {
        this.setProjectMultivalPreference(name, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(String path) {
        if (LangUtil.isEmpty(path)) {
            return;
        }
        File file = new File(path);
        if (!file.canRead()) {
            return;
        }
        FileInputStream in = null;
        try {
            path = UserPreferencesStore.getPropertiesFilePath();
            in = new FileInputStream(file);
            this.properties.load(in);
        }
        catch (IOException ioe) {
            Message msg = new Message("Error reading properties from " + path, IMessage.ERROR, ioe, null);
            Ajde.getDefault().getMessageHandler().handleMessage(msg);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        if (!this.persist) {
            return;
        }
        FileOutputStream out = null;
        String path = null;
        try {
            path = UserPreferencesStore.getPropertiesFilePath();
            out = new FileOutputStream(path);
            this.properties.store(out, "AJDE Settings");
        }
        catch (IOException ioe) {
            Message msg = new Message("Error writing properties to " + path, IMessage.ERROR, ioe, null);
            Ajde.getDefault().getMessageHandler().handleMessage(msg);
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

