/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.application;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.app.AppPersistence;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.application.ApplicationAdminPermission;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.application.ScheduledApplication;

public abstract class ApplicationDescriptor {
    public static final String APPLICATION_NAME = "application.name";
    public static final String APPLICATION_ICON = "application.icon";
    public static final String APPLICATION_PID = "service.pid";
    public static final String APPLICATION_VERSION = "application.version";
    public static final String APPLICATION_VENDOR = "service.vendor";
    public static final String APPLICATION_VISIBLE = "application.visible";
    public static final String APPLICATION_LAUNCHABLE = "application.launchable";
    public static final String APPLICATION_LOCKED = "application.locked";
    public static final String APPLICATION_DESCRIPTION = "application.description";
    public static final String APPLICATION_DOCUMENTATION = "application.documentation";
    public static final String APPLICATION_COPYRIGHT = "application.copyright";
    public static final String APPLICATION_LICENSE = "application.license";
    public static final String APPLICATION_CONTAINER = "application.container";
    public static final String APPLICATION_LOCATION = "application.location";
    private final String pid;
    private boolean[] locked = new boolean[1];

    protected ApplicationDescriptor(String applicationId) {
        if (applicationId == null) {
            throw new NullPointerException("Application ID must not be null!");
        }
        this.pid = applicationId;
        this.locked[0] = this.isLocked();
    }

    public final String getApplicationId() {
        return this.pid;
    }

    public abstract boolean matchDNChain(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map getProperties(String locale) {
        Map props = this.getPropertiesSpecific(locale);
        Boolean containerLocked = (Boolean)props.remove(APPLICATION_LOCKED);
        boolean[] blArray = this.locked;
        synchronized (this.locked) {
            if (containerLocked != null && containerLocked != this.locked[0]) {
                if (this.locked[0]) {
                    this.lockSpecific();
                } else {
                    this.unlockSpecific();
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            props.put(APPLICATION_LOCKED, new Boolean(this.locked[0]));
            return props;
        }
    }

    protected abstract Map getPropertiesSpecific(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ApplicationHandle launch(Map arguments) throws ApplicationException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ApplicationAdminPermission(this, "lifecycle"));
        }
        boolean[] blArray = this.locked;
        synchronized (this.locked) {
            if (this.locked[0]) {
                throw new ApplicationException(1, "Application is locked, can't launch!");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!this.isLaunchableSpecific()) {
                throw new ApplicationException(2, "Cannot launch the application!");
            }
            this.checkArgs(arguments);
            try {
                return this.launchSpecific(arguments);
            }
            catch (IllegalStateException ise) {
                throw ise;
            }
            catch (SecurityException se) {
                throw se;
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (Exception t) {
                throw new ApplicationException(3, (Throwable)t);
            }
        }
    }

    protected abstract ApplicationHandle launchSpecific(Map var1) throws Exception;

    protected abstract boolean isLaunchableSpecific();

    public final ScheduledApplication schedule(String scheduleId, Map arguments, String topic, String eventFilter, boolean recurring) throws InvalidSyntaxException, ApplicationException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ApplicationAdminPermission(this, "schedule"));
        }
        this.checkArgs(arguments);
        this.isLaunchableSpecific();
        return AppPersistence.addScheduledApp(this, scheduleId, arguments, topic, eventFilter, recurring);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void lock() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ApplicationAdminPermission(this, "lock"));
        }
        boolean[] blArray = this.locked;
        synchronized (this.locked) {
            if (this.locked[0]) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.locked[0] = true;
            this.lockSpecific();
            this.saveLock(true);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected abstract void lockSpecific();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlock() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ApplicationAdminPermission(this, "lock"));
        }
        boolean[] blArray = this.locked;
        synchronized (this.locked) {
            if (!this.locked[0]) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.locked[0] = false;
            this.unlockSpecific();
            this.saveLock(false);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected abstract void unlockSpecific();

    private void saveLock(boolean locked) {
        AppPersistence.saveLock(this, locked);
    }

    private boolean isLocked() {
        return AppPersistence.isLocked(this);
    }

    private void checkArgs(Map arguments) {
        if (arguments == null) {
            return;
        }
        Iterator keys = arguments.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Invalid key type: " + key == null ? "<null>" : key.getClass().getName());
            }
            if (!"".equals(key)) continue;
            throw new IllegalArgumentException("Empty string is an invalid key");
        }
    }
}

