/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.ldap.services.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.adaptors.ldap.services.DefaultLdapRegisteredServiceMapper;
import org.apereo.cas.adaptors.ldap.services.LdapRegisteredServiceMapper;
import org.apereo.cas.adaptors.ldap.services.LdapServiceRegistry;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.ldap.serviceregistry.LdapServiceRegistryProperties;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.util.LdapUtils;
import org.ldaptive.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration(value="LdapServiceRegistryConfiguration", proxyBeanMethods=false)
@ConditionalOnProperty(prefix="cas.service-registry.ldap", name={"ldap-url"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class LdapServiceRegistryConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapServiceRegistryConfiguration.class);

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"ldapServiceRegistryMapper"})
    public LdapRegisteredServiceMapper ldapServiceRegistryMapper(CasConfigurationProperties casProperties) {
        return new DefaultLdapRegisteredServiceMapper(casProperties.getServiceRegistry().getLdap());
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"ldapServiceRegistry"})
    public ServiceRegistry ldapServiceRegistry(@Qualifier(value="ldapServiceRegistryMapper") LdapRegisteredServiceMapper ldapServiceRegistryMapper, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<List<ServiceRegistryListener>> serviceRegistryListeners) {
        LdapServiceRegistryProperties ldap = casProperties.getServiceRegistry().getLdap();
        ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
        LOGGER.debug("Configured LDAP service registry search filter to [{}] and load filter to [{}]", (Object)ldap.getSearchFilter(), (Object)ldap.getLoadFilter());
        return new LdapServiceRegistry(connectionFactory, ldapServiceRegistryMapper, ldap, applicationContext, Optional.ofNullable((List)serviceRegistryListeners.getIfAvailable()).orElseGet(ArrayList::new));
    }

    @Bean
    @ConditionalOnMissingBean(name={"ldapServiceRegistryExecutionPlanConfigurer"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public ServiceRegistryExecutionPlanConfigurer ldapServiceRegistryExecutionPlanConfigurer(@Qualifier(value="ldapServiceRegistry") ServiceRegistry ldapServiceRegistry) {
        return plan -> plan.registerServiceRegistry(ldapServiceRegistry);
    }
}

