/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.ldap.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.ldap.services.DefaultLdapRegisteredServiceMapper;
import org.apereo.cas.adaptors.ldap.services.LdapRegisteredServiceMapper;
import org.apereo.cas.configuration.model.support.ldap.serviceregistry.LdapServiceRegistryProperties;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.support.events.service.CasRegisteredServiceLoadedEvent;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapUtils;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

public class LdapServiceRegistry
extends AbstractServiceRegistry
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapServiceRegistry.class);
    private final ConnectionFactory connectionFactory;
    private final LdapRegisteredServiceMapper ldapServiceMapper;
    private final LdapServiceRegistryProperties ldapProperties;

    public LdapServiceRegistry(ConnectionFactory connectionFactory, LdapRegisteredServiceMapper ldapServiceMapper, LdapServiceRegistryProperties ldapProperties, ConfigurableApplicationContext applicationContext, Collection<ServiceRegistryListener> serviceRegistryListeners) {
        super(applicationContext, serviceRegistryListeners);
        this.connectionFactory = connectionFactory;
        this.ldapProperties = ldapProperties;
        this.ldapServiceMapper = Objects.requireNonNullElseGet(ldapServiceMapper, () -> new DefaultLdapRegisteredServiceMapper(ldapProperties));
    }

    public RegisteredService save(RegisteredService rs) {
        this.invokeServiceRegistryListenerPreSave(rs);
        if (rs.getId() != -1L) {
            return this.update(rs);
        }
        this.insert(rs);
        return rs;
    }

    public boolean delete(RegisteredService registeredService) {
        SearchResponse response = this.searchForServiceById(registeredService.getId());
        if (LdapUtils.containsResultEntry((SearchResponse)response)) {
            LdapEntry entry = response.getEntry();
            return LdapUtils.executeDeleteOperation((ConnectionFactory)this.connectionFactory, (LdapEntry)entry);
        }
        LOGGER.debug("Could not locate registered service by id [{}] to delete", (Object)registeredService.getId());
        return false;
    }

    public void deleteAll() {
        SearchResponse response = this.getSearchResultResponse();
        if (LdapUtils.containsResultEntry((SearchResponse)response)) {
            response.getEntries().forEach(entry -> LdapUtils.executeDeleteOperation((ConnectionFactory)this.connectionFactory, (LdapEntry)entry));
        }
    }

    public Collection<RegisteredService> load() {
        ArrayList<RegisteredService> list = new ArrayList<RegisteredService>();
        SearchResponse response = this.getSearchResultResponse();
        if (LdapUtils.containsResultEntry((SearchResponse)response)) {
            response.getEntries().stream().map(this.ldapServiceMapper::mapToRegisteredService).filter(Objects::nonNull).map(arg_0 -> ((LdapServiceRegistry)this).invokeServiceRegistryListenerPostLoad(arg_0)).filter(Objects::nonNull).forEach(s -> {
                this.publishEvent((ApplicationEvent)new CasRegisteredServiceLoadedEvent((Object)this, s));
                list.add((RegisteredService)s);
            });
        }
        return list;
    }

    public RegisteredService findServiceById(long id) {
        SearchResponse response = this.searchForServiceById(id);
        if (LdapUtils.containsResultEntry((SearchResponse)response)) {
            return this.ldapServiceMapper.mapToRegisteredService(response.getEntry());
        }
        return null;
    }

    public long size() {
        SearchResponse response = this.getSearchResultResponse();
        if (LdapUtils.containsResultEntry((SearchResponse)response)) {
            return response.getEntries().stream().map(this.ldapServiceMapper::mapToRegisteredService).filter(Objects::nonNull).count();
        }
        return 0L;
    }

    public void destroy() {
        this.connectionFactory.close();
    }

    private RegisteredService insert(RegisteredService rs) {
        LdapEntry entry = this.ldapServiceMapper.mapFromRegisteredService(this.ldapProperties.getBaseDn(), rs);
        LdapUtils.executeAddOperation((ConnectionFactory)this.connectionFactory, (LdapEntry)entry);
        return rs;
    }

    private RegisteredService update(RegisteredService rs) {
        String currentDn = this.getCurrentDnForRegisteredService(rs);
        if (StringUtils.isNotBlank((CharSequence)currentDn)) {
            LOGGER.debug("Updating registered service at [{}]", (Object)currentDn);
            LdapEntry entry = this.ldapServiceMapper.mapFromRegisteredService(this.ldapProperties.getBaseDn(), rs);
            LdapUtils.executeModifyOperation((String)currentDn, (ConnectionFactory)this.connectionFactory, (LdapEntry)entry);
        } else {
            LOGGER.debug("Cannot locate DN for registered service with id [{}]. Attempting to save the service", (Object)rs.getId());
            this.insert(rs);
        }
        return rs;
    }

    private SearchResponse getSearchResultResponse() {
        FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter((String)this.ldapProperties.getLoadFilter());
        return LdapUtils.executeSearchOperation((ConnectionFactory)this.connectionFactory, (String)this.ldapProperties.getBaseDn(), (FilterTemplate)filter, (int)this.ldapProperties.getPageSize());
    }

    private SearchResponse searchForServiceById(Long id) {
        FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter((String)this.ldapProperties.getSearchFilter(), (String)"user", (List)CollectionUtils.wrap((Object)id.toString()));
        return LdapUtils.executeSearchOperation((ConnectionFactory)this.connectionFactory, (String)this.ldapProperties.getBaseDn(), (FilterTemplate)filter, (int)this.ldapProperties.getPageSize());
    }

    private String getCurrentDnForRegisteredService(RegisteredService rs) {
        SearchResponse response = this.searchForServiceById(rs.getId());
        if (LdapUtils.containsResultEntry((SearchResponse)response)) {
            return response.getEntry().getDn();
        }
        return null;
    }

    @Generated
    public String toString() {
        return "LdapServiceRegistry(connectionFactory=" + this.connectionFactory + ", ldapServiceMapper=" + this.ldapServiceMapper + ", ldapProperties=" + this.ldapProperties + ")";
    }
}

