/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.discovery;

import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.discovery.CasServerProfile;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.util.CollectionUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CasServerProfileRegistrar
implements ApplicationContextAware {
    private final CasConfigurationProperties casProperties;
    private final Clients clients;
    private final Set<String> availableAttributes;
    private final AuthenticationEventExecutionPlan authenticationEventExecutionPlan;
    private ApplicationContext applicationContext;

    private static Map<String, Class> locateRegisteredServiceTypesSupported() {
        Function<Class, Object> mapper = c -> {
            try {
                return (RegisteredService)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        };
        Collector<RegisteredService, ?, Map<String, Class>> collector = Collectors.toMap(RegisteredService::getFriendlyName, Object::getClass);
        return (Map)CasServerProfileRegistrar.locateSubtypesByReflection(mapper, collector, AbstractRegisteredService.class, o -> true, CentralAuthenticationService.NAMESPACE);
    }

    private static Object locateSubtypesByReflection(Function<Class, Object> mapper, Collector collector, Class parentType, Predicate filter, String packageNamespace) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packageNamespace, (ClassLoader[])new ClassLoader[0])));
        Set subTypes = reflections.getSubTypesOf(parentType);
        return subTypes.stream().filter(c -> !Modifier.isInterface(c.getModifiers()) && !Modifier.isAbstract(c.getModifiers()) && filter.test(c)).map(mapper).filter(Objects::nonNull).collect(collector);
    }

    public CasServerProfile getProfile() {
        CasServerProfile profile = new CasServerProfile();
        profile.setRegisteredServiceTypesSupported(CasServerProfileRegistrar.locateRegisteredServiceTypesSupported());
        profile.setMultifactorAuthenticationProviderTypesSupported(this.locateMultifactorAuthenticationProviderTypesSupported());
        profile.setDelegatedClientTypesSupported(this.locateDelegatedClientTypesSupported());
        profile.setAvailableAttributes(this.availableAttributes);
        profile.setUserDefinedScopes(this.casProperties.getAuthn().getOidc().getCore().getUserDefinedScopes().keySet());
        profile.setAvailableAuthenticationHandlers(this.locateAvailableAuthenticationHandlers());
        profile.setTicketTypesSupported(this.locateTicketTypesSupported());
        return profile;
    }

    private Map<String, Map<String, Object>> locateTicketTypesSupported() {
        TicketCatalog catalog = (TicketCatalog)this.applicationContext.getBean("ticketCatalog", TicketCatalog.class);
        return catalog.findAll().stream().collect(Collectors.toMap(TicketDefinition::getPrefix, value -> CollectionUtils.wrap((String)"storageName", (Object)value.getProperties().getStorageName(), (String)"storageTimeout", (Object)value.getProperties().getStorageTimeout())));
    }

    private Map<String, String> locateMultifactorAuthenticationProviderTypesSupported() {
        Map providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        return providers.values().stream().collect(Collectors.toMap(MultifactorAuthenticationProvider::getId, MultifactorAuthenticationProvider::getFriendlyName));
    }

    private Set<String> locateDelegatedClientTypesSupported() {
        if (this.clients == null) {
            return new LinkedHashSet<String>(0);
        }
        return this.clients.findAllClients().stream().map(Client::getName).collect(Collectors.toSet());
    }

    private Set<String> locateAvailableAuthenticationHandlers() {
        return this.authenticationEventExecutionPlan.getAuthenticationHandlers().stream().map(AuthenticationHandler::getName).collect(Collectors.toSet());
    }

    @Generated
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Generated
    public CasServerProfileRegistrar(CasConfigurationProperties casProperties, Clients clients, Set<String> availableAttributes, AuthenticationEventExecutionPlan authenticationEventExecutionPlan) {
        this.casProperties = casProperties;
        this.clients = clients;
        this.availableAttributes = availableAttributes;
        this.authenticationEventExecutionPlan = authenticationEventExecutionPlan;
    }
}

