/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.activation;

import javax.activation.DataHandler;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.mime.activation.PartDataHandler;
import org.apache.axiom.mime.activation.PartDataHandlerBlob;
import org.apache.axiom.util.activation.BlobDataHandler;
import org.apache.axiom.util.activation.DataHandlerBlob;

public final class DataHandlerUtils {
    private DataHandlerUtils() {
    }

    public static DataHandler getDataHandler(Blob blob) {
        if (blob instanceof DataHandlerBlob) {
            return ((DataHandlerBlob)blob).getDataHandler();
        }
        if (blob instanceof PartDataHandlerBlob) {
            return ((PartDataHandlerBlob)blob).getDataHandler();
        }
        return null;
    }

    public static DataHandler toDataHandler(Blob blob) {
        DataHandler dh = DataHandlerUtils.getDataHandler(blob);
        return dh != null ? dh : new BlobDataHandler(blob);
    }

    public static Blob toBlob(DataHandler dh) {
        if (dh instanceof BlobDataHandler) {
            return ((BlobDataHandler)dh).getBlob();
        }
        if (dh instanceof PartDataHandler) {
            return ((PartDataHandler)dh).getBlob();
        }
        return new DataHandlerBlob(dh);
    }
}

