/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.util.Vector;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.NamedNodeMapImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class AttributeMap
extends NamedNodeMapImpl {
    protected AttributeMap(ParentNode ownerNode) {
        super(ownerNode);
    }

    public Node removeNamedItem(String name) throws DOMException {
        return super.removeNamedItem(name);
    }

    public Node removeNamedItemNS(String namespaceURI, String name) throws DOMException {
        return super.removeNamedItemNS(namespaceURI, name);
    }

    public Node setNamedItem(Node attribute) throws DOMException {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 7, null);
            throw new DOMException(7, msg);
        }
        if (attribute.getOwnerDocument() != this.ownerNode.getOwnerDocument()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 4, null);
            throw new DOMException(4, msg);
        }
        if (attribute.getNodeType() != 2) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 3, null);
            throw new DOMException(3, msg);
        }
        AttrImpl attr = (AttrImpl)attribute;
        if (attr.isOwned()) {
            if (attr.getOwnerElement() != this.ownerNode) {
                throw new DOMException(10, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 10, null));
            }
            return attr;
        }
        attr.parent = this.ownerNode;
        attr.isOwned(true);
        attr.setUsed(true);
        int i = this.findNamePoint(attr.getNodeName(), 0);
        AttrImpl previous = null;
        if (i >= 0) {
            previous = (AttrImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(attr, i);
            previous.parent = this.ownerNode;
            previous.isOwned(false);
            previous.isSpecified(true);
        } else {
            i = -1 - i;
            if (null == this.nodes) {
                this.nodes = new Vector(5, 10);
            }
            this.nodes.insertElementAt(attr, i);
        }
        if (!attr.isNormalized()) {
            this.ownerNode.isNormalized(false);
        }
        return previous;
    }

    public Node setNamedItemNS(Node attribute) throws DOMException {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 7, null);
            throw new DOMException(7, msg);
        }
        if (attribute.getOwnerDocument() != this.ownerNode.getOwnerDocument()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 4, null);
            throw new DOMException(4, msg);
        }
        if (attribute.getNodeType() != 2) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 3, null);
            throw new DOMException(3, msg);
        }
        AttrImpl attr = (AttrImpl)attribute;
        if (attr.isOwned()) {
            if (attr.getOwnerElement() != this.ownerNode) {
                throw new DOMException(10, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 10, null));
            }
            return attr;
        }
        attr.ownerNode = (DocumentImpl)this.ownerNode.getOwnerDocument();
        attr.parent = this.ownerNode;
        attr.isOwned(true);
        int i = this.findNamePoint(attr.getNamespaceURI(), attr.getLocalName());
        AttrImpl previous = null;
        if (i >= 0) {
            previous = (AttrImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(attr, i);
            previous.ownerNode = (DocumentImpl)this.ownerNode.getOwnerDocument();
            previous.parent = null;
            previous.isOwned(false);
            previous.isSpecified(true);
        } else {
            i = this.findNamePoint(attr.getNodeName(), 0);
            if (i >= 0) {
                previous = (AttrImpl)this.nodes.elementAt(i);
                this.nodes.insertElementAt(attr, i);
            } else {
                i = -1 - i;
                if (null == this.nodes) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(attr, i);
            }
        }
        if (!attr.isNormalized()) {
            this.ownerNode.isNormalized(false);
        }
        return previous;
    }

    public NamedNodeMapImpl cloneMap(NodeImpl ownerNode) {
        AttributeMap newmap = new AttributeMap((ParentNode)ownerNode);
        newmap.hasDefaults(this.hasDefaults());
        newmap.cloneContent(this);
        return newmap;
    }

    protected void cloneContent(NamedNodeMapImpl srcmap) {
        int size;
        Vector srcnodes = srcmap.nodes;
        if (srcnodes != null && (size = srcnodes.size()) != 0) {
            if (this.nodes == null) {
                this.nodes = new Vector(size);
            }
            this.nodes.setSize(size);
            for (int i = 0; i < size; ++i) {
                NodeImpl n = (NodeImpl)srcnodes.elementAt(i);
                NodeImpl clone = (NodeImpl)n.cloneNode(true);
                clone.isSpecified(n.isSpecified());
                this.nodes.setElementAt(clone, i);
                clone.ownerNode = this.ownerNode.ownerNode;
                clone.isOwned(true);
            }
        }
    }
}

