/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rmi.provider;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.tuscany.sca.binding.rmi.RMIBinding;
import org.apache.tuscany.sca.binding.rmi.provider.RemoteInterfaceGenerator;
import org.apache.tuscany.sca.common.java.classloader.ClassLoaderDelegate;
import org.apache.tuscany.sca.host.rmi.RMIHost;
import org.apache.tuscany.sca.host.rmi.RMIHostException;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.oasisopen.sca.ServiceRuntimeException;

public class RMIServiceBindingProvider
implements ServiceBindingProvider {
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private RMIBinding binding;
    private RMIHost rmiHost;
    private RuntimeEndpoint endpoint;
    private Remote rmiProxy;

    public RMIServiceBindingProvider(RuntimeEndpoint endpoint, RMIHost rmiHost) {
        this.endpoint = endpoint;
        this.component = (RuntimeComponent)endpoint.getComponent();
        this.service = (RuntimeComponentService)endpoint.getService();
        this.binding = (RMIBinding)endpoint.getBinding();
        this.rmiHost = rmiHost;
    }

    public void start() {
        Interface serviceInterface = this.service.getInterfaceContract().getInterface();
        this.rmiProxy = this.createRmiService(serviceInterface);
        try {
            String uri = this.rmiHost.registerService(this.binding.getURI(), this.rmiProxy);
            this.binding.setURI(uri);
            this.endpoint.setDeployedURI(uri);
        }
        catch (RMIHostException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public void stop() {
        this.rmiHost.unregisterService(this.binding.getURI());
        try {
            UnicastRemoteObject.unexportObject(this.rmiProxy, false);
        }
        catch (NoSuchObjectException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private int getPort(String port) {
        int portNumber = 1099;
        if (port != null && port.length() > 0) {
            portNumber = Integer.decode(port);
        }
        return portNumber;
    }

    private Remote createRmiService(final Interface serviceInterface) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(UnicastRemoteObject.class);
        enhancer.setCallback((Callback)new MethodInterceptor(){

            public Object intercept(Object arg0, Method method, Object[] args, MethodProxy arg3) throws Throwable {
                try {
                    return RMIServiceBindingProvider.this.invokeTarget(JavaInterfaceUtil.findOperation((Method)method, (Collection)serviceInterface.getOperations()), args);
                }
                catch (InvocationTargetException e) {
                    final Throwable cause = e.getCause();
                    for (Class<?> declaredType : method.getExceptionTypes()) {
                        if (!declaredType.isInstance(cause)) continue;
                        throw e;
                    }
                    if (cause.getCause() != null) {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                Field field = Throwable.class.getDeclaredField("cause");
                                field.setAccessible(true);
                                field.set(cause, null);
                                field.setAccessible(false);
                                return null;
                            }
                        });
                    }
                    throw cause;
                }
            }
        });
        Class<Object> targetJavaInterface = this.getTargetJavaClass(serviceInterface);
        targetJavaInterface = RemoteInterfaceGenerator.generate(targetJavaInterface);
        enhancer.setClassLoader((ClassLoader)new ClassLoaderDelegate(targetJavaInterface.getClassLoader(), new ClassLoader[]{this.getClass().getClassLoader()}));
        enhancer.setInterfaces(new Class[]{targetJavaInterface});
        return (Remote)enhancer.create();
    }

    private Object invokeTarget(Operation op, Object[] args) throws InvocationTargetException {
        return this.endpoint.invoke(op, args);
    }

    private Class<?> getTargetJavaClass(Interface targetInterface) {
        return ((JavaInterface)targetInterface).getJavaClass();
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.service.getInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }
}

