/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rmi.provider;

import java.lang.reflect.Method;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.rmi.RMIBinding;
import org.apache.tuscany.sca.binding.rmi.provider.RMIBindingInvoker;
import org.apache.tuscany.sca.host.rmi.RMIHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;

public class RMIReferenceBindingProvider
implements ReferenceBindingProvider {
    private RuntimeComponentReference reference;
    private EndpointReference endpointReference;
    private RMIBinding binding;
    private RMIHost rmiHost;

    public RMIReferenceBindingProvider(EndpointReference endpointReference, RMIHost rmiHost) {
        this.endpointReference = endpointReference;
        this.reference = (RuntimeComponentReference)endpointReference.getReference();
        this.binding = (RMIBinding)endpointReference.getBinding();
        this.rmiHost = rmiHost;
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.reference.getInterfaceContract();
    }

    public Invoker createInvoker(Operation operation) {
        Method remoteMethod;
        Class iface = ((JavaInterface)this.reference.getInterfaceContract().getInterface()).getJavaClass();
        try {
            remoteMethod = JavaInterfaceUtil.findMethod((Class)iface, (Operation)operation);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        return new RMIBindingInvoker(this.rmiHost, this.endpointReference.getDeployedURI(), remoteMethod);
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }
}

