/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rmi.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.UnexpectedException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tuscany.sca.host.rmi.RMIHost;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;

public class RMIBindingInvoker
implements Invoker {
    private RMIHost rmiHost;
    private String uri;
    private Method remoteMethod;
    private Remote proxy;

    public RMIBindingInvoker(RMIHost rmiHost, String uri, Method remoteMethod) {
        this.rmiHost = rmiHost;
        this.remoteMethod = remoteMethod;
        this.uri = uri;
    }

    public Message invoke(Message msg) {
        try {
            Object[] args = (Object[])msg.getBody();
            Object resp = this.invokeTarget(args);
            msg.setBody(resp);
        }
        catch (InvocationTargetException e) {
            msg.setFaultBody((Object)e.getCause());
        }
        catch (Throwable e) {
            msg.setFaultBody((Object)e);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeTarget(Object payload) throws InvocationTargetException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException {
        Object invocationResult;
        block7: {
            if (this.proxy == null) {
                this.initProxy();
            }
            invocationResult = null;
            InvocationTargetException rethrow = null;
            try {
                invocationResult = this.doInvokeTarget(payload);
            }
            catch (InvocationTargetException e) {
                block8: {
                    rethrow = e;
                    Throwable cause = e.getCause();
                    if (!(cause instanceof UndeclaredThrowableException)) break block8;
                    if (!((cause = cause.getCause()) instanceof UnexpectedException)) break;
                    if ((cause = cause.getCause()) instanceof ConnectException) {
                        rethrow = null;
                        this.proxy = this.rmiHost.findService(this.uri);
                        invocationResult = this.doInvokeTarget(payload);
                        return invocationResult;
                    }
                    break;
                }
            }
            finally {
                if (rethrow == null) break block7;
                throw rethrow;
            }
        }
        return invocationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initProxy() {
        if (this.proxy == null) {
            Class<?> remote = this.remoteMethod.getDeclaringClass();
            final ClassLoader stubClassLoader = remote.getClassLoader();
            ClassLoader tccl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(stubClassLoader);
                    return tccl;
                }
            });
            try {
                this.proxy = this.rmiHost.findService(this.uri);
            }
            catch (Throwable throwable) {
                AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(tccl){
                    final /* synthetic */ ClassLoader val$tccl;
                    {
                        this.val$tccl = classLoader;
                    }

                    @Override
                    public ClassLoader run() {
                        ClassLoader current = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.val$tccl);
                        return current;
                    }
                });
                throw throwable;
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private Object doInvokeTarget(Object payload) throws InvocationTargetException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException {
        this.remoteMethod = this.proxy.getClass().getMethod(this.remoteMethod.getName(), this.remoteMethod.getParameterTypes());
        if (payload != null && !payload.getClass().isArray()) {
            return this.remoteMethod.invoke((Object)this.proxy, payload);
        }
        return this.remoteMethod.invoke((Object)this.proxy, (Object[])payload);
    }
}

