/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.tuscany.sca.binding.ejb.corba.Java2IDLUtil;
import org.apache.tuscany.sca.binding.ejb.util.MethodInfo;

class InterfaceInfo
implements Serializable {
    private static final Map<Class, InterfaceInfo> INTERFACES = Collections.synchronizedMap(new WeakHashMap());
    private static final long serialVersionUID = 2314533906465094860L;
    private String name;
    private Map<String, MethodInfo> methods = new HashMap<String, MethodInfo>();

    InterfaceInfo(final Class iface) {
        if (iface == null) {
            throw new IllegalArgumentException("The interface cannot be null");
        }
        this.name = iface.getName();
        Map idlNames = AccessController.doPrivileged(new PrivilegedAction<Map>(){

            @Override
            public Map run() {
                return Java2IDLUtil.mapMethodToOperation(iface);
            }
        });
        for (Map.Entry entry : idlNames.entrySet()) {
            Method method = (Method)entry.getKey();
            MethodInfo methodInfo = new MethodInfo(method);
            methodInfo.setIDLName((String)entry.getValue());
            this.methods.put(method.getName(), methodInfo);
            this.methods.put(methodInfo.getIDLName(), methodInfo);
        }
    }

    static final synchronized InterfaceInfo getInstance(Class iface) {
        InterfaceInfo info = INTERFACES.get(iface);
        if (info == null) {
            info = new InterfaceInfo(iface);
            INTERFACES.put(iface, info);
        }
        return info;
    }

    Map<String, MethodInfo> getMethods() {
        return this.methods;
    }

    MethodInfo getMethod(String name) {
        return this.methods.get(name);
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("interface ").append(this.name).append("{ \n");
        for (MethodInfo methodInfo : this.methods.values()) {
            sb.append("\t").append(methodInfo).append("\n");
        }
        sb.append("};\n");
        return sb.toString();
    }
}

