/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBObject;
import javax.rmi.CORBA.Util;
import org.apache.tuscany.sca.binding.ejb.corba.ClassLoadingUtil;
import org.apache.tuscany.sca.binding.ejb.corba.Java2IDLUtil;
import org.apache.tuscany.sca.binding.ejb.util.EJBStubHelper;
import org.apache.tuscany.sca.binding.ejb.util.InterfaceInfo;
import org.apache.tuscany.sca.binding.ejb.util.JavaReflectionAdapter;
import org.apache.tuscany.sca.binding.ejb.util.MethodInfo;
import org.apache.tuscany.sca.binding.ejb.util.NamingEndpoint;
import org.oasisopen.sca.ServiceRuntimeException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.ServantObject;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class EJBHandler {
    private static final Map<String, Class> PRIMITIVE_TYPES = new HashMap<String, Class>();
    private Object ejbStub;
    private InterfaceInfo interfaceInfo;
    private Class ejbInterface;

    public EJBHandler(NamingEndpoint namingEndpoint, Class ejbInterface) {
        this(namingEndpoint, InterfaceInfo.getInstance(ejbInterface));
        this.ejbInterface = ejbInterface;
    }

    private EJBHandler(NamingEndpoint namingEndpoint, InterfaceInfo ejbInterface) {
        try {
            this.ejbStub = EJBStubHelper.lookup(namingEndpoint, ejbInterface);
            this.interfaceInfo = ejbInterface;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private static Class loadClass(String name) {
        try {
            return ClassLoadingUtil.loadClass(name, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public Object invoke(String methodName, Object[] args) {
        Object response = null;
        try {
            if (this.ejbStub instanceof ObjectImpl) {
                ObjectImpl objectImpl = (ObjectImpl)this.ejbStub;
                response = System.getSecurityManager() == null && objectImpl._is_local() ? this.invokeLocalCORBACall(objectImpl, methodName, args) : this.invokeRemoteCORBACall(objectImpl, methodName, args);
            } else {
                JavaReflectionAdapter reflectionAdapter = JavaReflectionAdapter.createJavaReflectionAdapter(this.ejbStub.getClass());
                try {
                    Method method = reflectionAdapter.getMethod(methodName);
                    response = method.invoke(this.ejbStub, args);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    throw new ServiceRuntimeException(t);
                }
            }
            return response;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
    }

    private String getOperation(String methodName) {
        if (this.interfaceInfo == null) {
            return methodName;
        }
        MethodInfo methodInfo = this.interfaceInfo.getMethod(methodName);
        if (methodInfo != null) {
            return methodInfo.getIDLName();
        }
        return null;
    }

    private static String getInterface(String stubName) {
        int index = stubName.lastIndexOf(46);
        String packageName = null;
        String typeName = stubName;
        if (index != -1) {
            packageName = stubName.substring(0, index);
            if (packageName.startsWith("org.omg.stub.")) {
                packageName = packageName.substring("org.omg.stub.".length());
            }
            typeName = stubName.substring(index + 1);
        }
        if (typeName.startsWith("_") && typeName.endsWith("_Stub")) {
            typeName = typeName.substring(1, typeName.length() - "_Stub".length());
        }
        if (packageName != null) {
            return packageName + "." + typeName;
        }
        return typeName;
    }

    private Object invokeLocalCORBACall(ObjectImpl stub, String methodName, Object[] args) throws RemoteException {
        ServantObject so;
        String operation = this.getOperation(methodName);
        Class type = EJBHandler.loadClass(EJBHandler.getInterface(stub.getClass().getName()));
        if (type == null) {
            Class clazz = type = this.ejbInterface != null ? this.ejbInterface : EJBObject.class;
        }
        if ((so = stub._servant_preinvoke(operation, type)) == null) {
            return this.invokeRemoteCORBACall(stub, methodName, args);
        }
        Object[] newArgs = null;
        ORB orb = stub._orb();
        try {
            Object result;
            if (args != null) {
                newArgs = Util.copyObjects((Object[])args, (ORB)orb);
            }
            JavaReflectionAdapter reflectionAdapter = JavaReflectionAdapter.createJavaReflectionAdapter(so.servant.getClass());
            Method method = reflectionAdapter.getMethod(methodName);
            Object obj = reflectionAdapter.invoke(method, so.servant, newArgs);
            Object object = result = Util.copyObject((Object)obj, (ORB)orb);
            return object;
        }
        catch (InvocationTargetException e) {
            Throwable exCopy = (Throwable)Util.copyObject((Object)e.getTargetException(), (ORB)orb);
            MethodInfo methodInfo = this.interfaceInfo.getMethod(methodName);
            String[] exceptionTypes = methodInfo.getExceptionTypes();
            for (int i = 0; i < exceptionTypes.length; ++i) {
                Class<?> exceptionType;
                Class<?> clazz = exceptionType = methodInfo.getMethod() != null ? methodInfo.getMethod().getExceptionTypes()[i] : EJBHandler.loadClass(exceptionTypes[i]);
                if (!exceptionType.isAssignableFrom(exCopy.getClass())) continue;
                throw new ServiceRuntimeException(exCopy);
            }
            throw Util.wrapException((Throwable)exCopy);
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
        finally {
            stub._servant_postinvoke(so);
        }
    }

    /*
     * Exception decompiling
     */
    private Object invokeRemoteCORBACall(ObjectImpl stub, String methodName, Object[] args) throws RemoteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK], 11[CATCHBLOCK], 10[CATCHBLOCK], 4[TRYBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeValue(OutputStream out, Object value, Class type) {
        Java2IDLUtil.writeObject(type, value, out);
    }

    private Object readValue(InputStream in, Class type) {
        return Java2IDLUtil.readObject(type, in);
    }

    static {
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        PRIMITIVE_TYPES.put("void", Void.TYPE);
    }
}

