/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.corba;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.spi.HandleDelegate;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.apache.tuscany.sca.binding.ejb.corba.ObjectInputStreamExt;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.Encoding;

public final class Java2IDLUtil {
    private static ORB orb;
    private static Codec codec;
    private static HandleDelegate handleDelegate;
    private static final Pattern SCOPED_NAME_EXTRACTION_PATTERN;
    private static final Pattern SCOPED_NAME_ESCAPE_PATTERN;
    private static final char[] HEXCHAR;
    private static final Map specialTypeNames;
    private static final Map specialTypePackages;
    private static final Set keywords;

    public static ORB getORB() {
        assert (orb != null);
        return orb;
    }

    public static void setORB(ORB orb) throws UserException {
        if (Java2IDLUtil.orb == null) {
            Java2IDLUtil.orb = orb;
            CodecFactory factory = (CodecFactory)Java2IDLUtil.orb.resolve_initial_references("CodecFactory");
            codec = factory.create_codec(new Encoding(0, 1, 2));
        }
    }

    public static Codec getCodec() {
        assert (codec != null);
        return codec;
    }

    public static HandleDelegate getHandleDelegate() throws NamingException {
        if (handleDelegate == null) {
            InitialContext ic = new InitialContext();
            handleDelegate = (HandleDelegate)ic.lookup("java:comp/HandleDelegate");
        }
        return handleDelegate;
    }

    public static String extractUserNameFromScopedName(byte[] scopedNameBytes) throws UnsupportedEncodingException {
        String scopedUserName = new String(scopedNameBytes, "UTF8");
        return Java2IDLUtil.extractUserNameFromScopedName(scopedUserName);
    }

    public static String extractUserNameFromScopedName(String scopedUserName) {
        Matcher m = SCOPED_NAME_EXTRACTION_PATTERN.matcher(scopedUserName);
        StringBuffer buf = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(buf, "");
            if (m.group(1) != null) {
                buf.append('\\');
                continue;
            }
            if (m.group(2) != null) {
                buf.append("@");
                continue;
            }
            if (m.group(3) == null) continue;
            break;
        }
        return buf.toString();
    }

    public static String buildScopedUserName(String user, String domain) {
        StringBuffer buf = new StringBuffer();
        if (user != null) {
            Java2IDLUtil.escape(user, buf);
        }
        if (domain != null) {
            buf.append('@');
            Java2IDLUtil.escape(domain, buf);
        }
        return buf.toString();
    }

    private static void escape(String s, StringBuffer buf) {
        Matcher m = SCOPED_NAME_ESCAPE_PATTERN.matcher(s);
        while (m.find()) {
            m.appendReplacement(buf, "");
            if (m.group(1) != null) {
                buf.append("\\\\");
                continue;
            }
            if (m.group(2) == null) continue;
            buf.append("\\@");
        }
        m.appendTail(buf);
    }

    public static String byteToString(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            buffer.append(HEXCHAR[data[i] >>> 4 & 0xF]);
            buffer.append(HEXCHAR[data[i] & 0xF]);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(Class type, java.lang.Object object, OutputStream out) {
        if (type != Void.TYPE) {
            if (type == Boolean.TYPE) {
                out.write_boolean(((Boolean)object).booleanValue());
            } else if (type == Byte.TYPE) {
                out.write_octet(((Byte)object).byteValue());
            } else if (type == Character.TYPE) {
                out.write_wchar(((Character)object).charValue());
            } else if (type == Double.TYPE) {
                out.write_double(((Double)object).doubleValue());
            } else if (type == Float.TYPE) {
                out.write_float(((Float)object).floatValue());
            } else if (type == Integer.TYPE) {
                out.write_long(((Integer)object).intValue());
            } else if (type == Long.TYPE) {
                out.write_longlong(((Long)object).longValue());
            } else if (type == Short.TYPE) {
                out.write_short(((Short)object).shortValue());
            } else {
                if (object instanceof Serializable && !object.getClass().isArray()) {
                    try {
                        object = Java2IDLUtil.copyObj(Thread.currentThread().getContextClassLoader(), object);
                    }
                    catch (Exception e) {
                        throw new UnknownException((Throwable)e);
                    }
                }
                if (type == java.lang.Object.class || type == Serializable.class) {
                    Util.writeAny((org.omg.CORBA.portable.OutputStream)out, (java.lang.Object)object);
                } else if (Object.class.isAssignableFrom(type)) {
                    out.write_Object((Object)object);
                } else if (Remote.class.isAssignableFrom(type)) {
                    Util.writeRemoteObject((org.omg.CORBA.portable.OutputStream)out, (java.lang.Object)object);
                } else if (type.isInterface() && Serializable.class.isAssignableFrom(type)) {
                    Util.writeAbstractObject((org.omg.CORBA.portable.OutputStream)out, (java.lang.Object)object);
                } else {
                    out.write_value((Serializable)object, type);
                }
            }
        }
    }

    private static java.lang.Object copyObj(ClassLoader classLoader, java.lang.Object object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.flush();
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStreamExt ois = new ObjectInputStreamExt(bais, classLoader);
        return ois.readObject();
    }

    public static java.lang.Object readObject(Class type, InputStream in) {
        if (type == Void.TYPE) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return new Boolean(in.read_boolean());
        }
        if (type == Byte.TYPE) {
            return new Byte(in.read_octet());
        }
        if (type == Character.TYPE) {
            return new Character(in.read_wchar());
        }
        if (type == Double.TYPE) {
            return new Double(in.read_double());
        }
        if (type == Float.TYPE) {
            return new Float(in.read_float());
        }
        if (type == Integer.TYPE) {
            return new Integer(in.read_long());
        }
        if (type == Long.TYPE) {
            return new Long(in.read_longlong());
        }
        if (type == Short.TYPE) {
            return new Short(in.read_short());
        }
        if (type == java.lang.Object.class || type == Serializable.class) {
            return Util.readAny((org.omg.CORBA.portable.InputStream)in);
        }
        if (Object.class.isAssignableFrom(type)) {
            return in.read_Object(type);
        }
        if (Remote.class.isAssignableFrom(type)) {
            return PortableRemoteObject.narrow((java.lang.Object)in.read_Object(), (Class)type);
        }
        if (type.isInterface() && Serializable.class.isAssignableFrom(type)) {
            return in.read_abstract_interface();
        }
        return in.read_value(type);
    }

    public static void throwException(Method method, InputStream in) throws Throwable {
        String id = in.read_string();
        if (!id.startsWith("IDL:")) {
            return;
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            Class<?> exceptionType = exceptionTypes[i];
            String exceptionId = Java2IDLUtil.getExceptionId(exceptionType);
            if (!id.equals(exceptionId)) continue;
            throw (Throwable)in.read_value(exceptionType);
        }
        throw new UnexpectedException(id);
    }

    public static OutputStream writeUserException(Method method, ResponseHandler reply, Exception exception) throws Exception {
        if (exception instanceof RuntimeException || exception instanceof RemoteException) {
            throw exception;
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            Class<?> exceptionType = exceptionTypes[i];
            if (!exceptionType.isInstance(exception)) continue;
            OutputStream out = (OutputStream)reply.createExceptionReply();
            String exceptionId = Java2IDLUtil.getExceptionId(exceptionType);
            out.write_string(exceptionId);
            out.write_value((Serializable)exception);
            return out;
        }
        throw exception;
    }

    public static String getExceptionId(Class exceptionType) {
        String exceptionName = exceptionType.getName().replace('.', '/');
        if (exceptionName.endsWith("Exception")) {
            exceptionName = exceptionName.substring(0, exceptionName.length() - "Exception".length());
        }
        exceptionName = exceptionName + "Ex";
        String exceptionId = "IDL:" + exceptionName + ":1.0";
        return exceptionId;
    }

    public static String[] createCorbaIds(Class type) {
        LinkedList<String> ids = new LinkedList<String>();
        for (Class superInterface : Java2IDLUtil.getAllInterfaces(type)) {
            if (!Remote.class.isAssignableFrom(superInterface) || superInterface == Remote.class) continue;
            ids.add("RMI:" + superInterface.getName() + ":0000000000000000");
        }
        return ids.toArray(new String[ids.size()]);
    }

    private static Set getAllInterfaces(Class intfClass) {
        LinkedHashSet<Class> allInterfaces = new LinkedHashSet<Class>();
        LinkedList stack = new LinkedList();
        stack.addFirst(intfClass);
        while (!stack.isEmpty()) {
            Class intf = (Class)stack.removeFirst();
            allInterfaces.add(intf);
            stack.addAll(0, Arrays.asList(intf.getInterfaces()));
        }
        return allInterfaces;
    }

    public static Map mapMethodToOperation(Class intfClass) {
        return Java2IDLUtil.iiopMap(intfClass, false);
    }

    public static Map mapOperationToMethod(Class intfClass) {
        return Java2IDLUtil.iiopMap(intfClass, true);
    }

    private static Map iiopMap(Class intfClass, boolean operationToMethod) {
        Class<?> exceptionType;
        Class<?>[] exceptionTypes;
        boolean exceptionsValid;
        Method[] methods = Java2IDLUtil.getAllMethods(intfClass);
        HashMap<Method, String> getterByMethod = new HashMap<Method, String>(methods.length);
        HashMap<String, Method> getterByName = new HashMap<String, Method>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            String verb;
            Method method = methods[i];
            String methodName = method.getName();
            if (method.getParameterTypes().length != 0) continue;
            if (methodName.startsWith("get") && methodName.length() > 3 && method.getReturnType() != Void.TYPE) {
                verb = "get";
            } else {
                if (!methodName.startsWith("is") || methodName.length() <= 2 || method.getReturnType() != Boolean.TYPE) continue;
                verb = "is";
            }
            exceptionsValid = true;
            exceptionTypes = method.getExceptionTypes();
            for (int j = 0; j < exceptionTypes.length; ++j) {
                exceptionType = exceptionTypes[j];
                if (RemoteException.class.isAssignableFrom(exceptionType) || RuntimeException.class.isAssignableFrom(exceptionType) || Error.class.isAssignableFrom(exceptionType)) continue;
                exceptionsValid = false;
                break;
            }
            if (!exceptionsValid) continue;
            String propertyName = methodName.length() > verb.length() + 1 && Character.isUpperCase(methodName.charAt(verb.length() + 1)) ? methodName.substring(verb.length()) : Character.toLowerCase(methodName.charAt(verb.length())) + methodName.substring(verb.length() + 1);
            getterByMethod.put(method, propertyName);
            getterByName.put(propertyName, method);
        }
        HashMap<Method, String> setterByMethod = new HashMap<Method, String>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            String propertyName;
            Method getter;
            Method method = methods[i];
            String methodName = method.getName();
            if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE || !methodName.startsWith("set") || methodName.length() <= 3) continue;
            exceptionsValid = true;
            exceptionTypes = method.getExceptionTypes();
            for (int j = 0; j < exceptionTypes.length; ++j) {
                exceptionType = exceptionTypes[j];
                if (RemoteException.class.isAssignableFrom(exceptionType) || RuntimeException.class.isAssignableFrom(exceptionType) || Error.class.isAssignableFrom(exceptionType)) continue;
                exceptionsValid = false;
                break;
            }
            if (!exceptionsValid || (getter = (Method)getterByName.get(propertyName = methodName.length() > 4 && Character.isUpperCase(methodName.charAt(4)) ? methodName.substring(3) : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4))) == null || !method.getParameterTypes()[0].equals(getter.getReturnType())) continue;
            setterByMethod.put(method, propertyName);
        }
        HashMap<String, LinkedList<Method>> overloadedMethods = new HashMap<String, LinkedList<Method>>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (getterByMethod.containsKey(method) || setterByMethod.containsKey(method)) continue;
            String methodName = method.getName();
            LinkedList<Method> methodList = (LinkedList<Method>)overloadedMethods.get(methodName);
            if (methodList == null) {
                methodList = new LinkedList<Method>();
                overloadedMethods.put(methodName, methodList);
            }
            methodList.add(method);
        }
        HashMap<String, HashSet<String>> caseCollisionMethods = new HashMap<String, HashSet<String>>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (getterByMethod.containsKey(method) || setterByMethod.containsKey(method)) continue;
            String lowerCaseMethodName = method.getName().toLowerCase();
            HashSet<String> methodSet = (HashSet<String>)caseCollisionMethods.get(lowerCaseMethodName);
            if (methodSet == null) {
                methodSet = new HashSet<String>();
                caseCollisionMethods.put(lowerCaseMethodName, methodSet);
            }
            methodSet.add(method.getName());
        }
        String className = Java2IDLUtil.getClassName(intfClass);
        HashMap<java.lang.Object, java.lang.Object> iiopMap = new HashMap<java.lang.Object, java.lang.Object>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            List overloads;
            Method method = methods[i];
            String iiopName = (String)getterByMethod.get(method);
            if (iiopName != null) {
                iiopName = iiopName.charAt(0) == '_' ? "J_get_" + iiopName.substring(1) : "_get_" + iiopName;
            } else {
                iiopName = (String)setterByMethod.get(method);
                if (iiopName != null) {
                    iiopName = iiopName.charAt(0) == '_' ? "J_set_" + iiopName.substring(1) : "_set_" + iiopName;
                } else {
                    iiopName = method.getName();
                    if (iiopName.charAt(0) == '_') {
                        iiopName = "J" + iiopName;
                    }
                }
            }
            Set caseCollisions = (Set)caseCollisionMethods.get(method.getName().toLowerCase());
            if (caseCollisions != null && caseCollisions.size() > 1) {
                iiopName = iiopName + Java2IDLUtil.upperCaseIndexString(iiopName);
            }
            if ((overloads = (List)overloadedMethods.get(method.getName())) != null && overloads.size() > 1) {
                iiopName = iiopName + Java2IDLUtil.buildOverloadParameterString(method.getParameterTypes());
            }
            if (keywords.contains((iiopName = Java2IDLUtil.replace(iiopName, '$', "U0024")).toLowerCase())) {
                iiopName = "_" + iiopName;
            }
            if (iiopName.equalsIgnoreCase(className)) {
                iiopName = iiopName + "_";
            }
            if (operationToMethod) {
                iiopMap.put(iiopName, method);
                continue;
            }
            iiopMap.put(method, iiopName);
        }
        return iiopMap;
    }

    private static Method[] getAllMethods(Class intfClass) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Class intf : Java2IDLUtil.getAllInterfaces(intfClass)) {
            methods.addAll(Arrays.asList(intf.getDeclaredMethods()));
        }
        return methods.toArray(new Method[methods.size()]);
    }

    private static String upperCaseIndexString(String iiopName) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < iiopName.length(); ++i) {
            char c = iiopName.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            stringBuffer.append('_').append(i);
        }
        return stringBuffer.toString();
    }

    private static String replace(String source, char oldChar, String newString) {
        StringBuffer stringBuffer = new StringBuffer(source.length());
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == oldChar) {
                stringBuffer.append(newString);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String buildOverloadParameterString(Class[] parameterTypes) {
        String name = "";
        if (parameterTypes.length == 0) {
            name = name + "__";
        } else {
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class parameterType = parameterTypes[i];
                name = name + Java2IDLUtil.buildOverloadParameterString(parameterType);
            }
        }
        return name.replace('.', '_');
    }

    private static String buildOverloadParameterString(Class parameterType) {
        String className;
        String packageName;
        String name = "_";
        int arrayDimensions = 0;
        while (parameterType.isArray()) {
            ++arrayDimensions;
            parameterType = parameterType.getComponentType();
        }
        if (arrayDimensions > 0) {
            name = name + "_org_omg_boxedRMI";
        }
        if (IDLEntity.class.isAssignableFrom(parameterType)) {
            name = name + "_org_omg_boxedIDL";
        }
        if ((packageName = (String)specialTypePackages.get(parameterType.getName())) == null) {
            packageName = Java2IDLUtil.getPackageName(parameterType.getName());
        }
        if (packageName.length() > 0) {
            name = name + "_" + packageName;
        }
        if (arrayDimensions > 0) {
            name = name + "_seq" + arrayDimensions;
        }
        if ((className = (String)specialTypeNames.get(parameterType.getName())) == null) {
            className = Java2IDLUtil.buildClassName(parameterType);
        }
        name = name + "_" + className;
        return name;
    }

    private static String buildClassName(Class type) {
        if (type.isArray()) {
            throw new IllegalArgumentException("type is an array: " + type);
        }
        String typeName = type.getName();
        int endIndex = typeName.lastIndexOf(46);
        if (endIndex < 0) {
            return typeName;
        }
        StringBuffer className = new StringBuffer(typeName.substring(endIndex + 1));
        if (type.getDeclaringClass() != null) {
            String declaringClassName = Java2IDLUtil.getClassName(type.getDeclaringClass());
            assert (className.toString().startsWith(declaringClassName + "$"));
            className.replace(declaringClassName.length(), declaringClassName.length() + 1, "__");
        }
        if (className.charAt(0) == '_') {
            className.insert(0, "J");
        }
        return className.toString();
    }

    private static String getClassName(Class type) {
        if (type.isArray()) {
            throw new IllegalArgumentException("type is an array: " + type);
        }
        String typeName = type.getName();
        int endIndex = typeName.lastIndexOf(46);
        if (endIndex < 0) {
            return typeName;
        }
        return typeName.substring(endIndex + 1);
    }

    private static String getPackageName(String interfaceName) {
        int endIndex = interfaceName.lastIndexOf(46);
        if (endIndex < 0) {
            return "";
        }
        return interfaceName.substring(0, endIndex);
    }

    static {
        SCOPED_NAME_EXTRACTION_PATTERN = Pattern.compile("(\\\\\\\\)|(\\\\@)|(@)|(\\z)");
        SCOPED_NAME_ESCAPE_PATTERN = Pattern.compile("(\\\\)|(@)");
        HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        specialTypeNames = new HashMap();
        specialTypeNames.put("boolean", "boolean");
        specialTypeNames.put("char", "wchar");
        specialTypeNames.put("byte", "octet");
        specialTypeNames.put("short", "short");
        specialTypeNames.put("int", "long");
        specialTypeNames.put("long", "long_long");
        specialTypeNames.put("float", "float");
        specialTypeNames.put("double", "double");
        specialTypeNames.put("java.lang.Class", "ClassDesc");
        specialTypeNames.put("java.lang.String", "WStringValue");
        specialTypeNames.put("org.omg.CORBA.Object", "Object");
        specialTypePackages = new HashMap();
        specialTypePackages.put("boolean", "");
        specialTypePackages.put("char", "");
        specialTypePackages.put("byte", "");
        specialTypePackages.put("short", "");
        specialTypePackages.put("int", "");
        specialTypePackages.put("long", "");
        specialTypePackages.put("float", "");
        specialTypePackages.put("double", "");
        specialTypePackages.put("java.lang.Class", "javax.rmi.CORBA");
        specialTypePackages.put("java.lang.String", "CORBA");
        specialTypePackages.put("org.omg.CORBA.Object", "");
        keywords = new HashSet();
        keywords.add("abstract");
        keywords.add("any");
        keywords.add("attribute");
        keywords.add("boolean");
        keywords.add("case");
        keywords.add("char");
        keywords.add("const");
        keywords.add("context");
        keywords.add("custom");
        keywords.add("default");
        keywords.add("double");
        keywords.add("enum");
        keywords.add("exception");
        keywords.add("factory");
        keywords.add("false");
        keywords.add("fixed");
        keywords.add("float");
        keywords.add("in");
        keywords.add("inout");
        keywords.add("interface");
        keywords.add("long");
        keywords.add("module");
        keywords.add("native");
        keywords.add("object");
        keywords.add("octet");
        keywords.add("oneway");
        keywords.add("out");
        keywords.add("private");
        keywords.add("public");
        keywords.add("raises");
        keywords.add("readonly");
        keywords.add("sequence");
        keywords.add("short");
        keywords.add("string");
        keywords.add("struct");
        keywords.add("supports");
        keywords.add("switch");
        keywords.add("true");
        keywords.add("truncatable");
        keywords.add("typedef");
        keywords.add("union");
        keywords.add("unsigned");
        keywords.add("valuebase");
        keywords.add("valuetype");
        keywords.add("void");
        keywords.add("wchar");
        keywords.add("wstring");
    }
}

