/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import java.io.File;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;

public class Main {
    public static final String PORT = "port";
    public static final String SHUTDOWN = "shutdown";
    public static final String PATH = "path";
    public static final String CONTEXT = "context";
    public static final String DIRECTORY = "directory";
    public static final String DOC_BASE = "doc-base";
    public static final String AS_WAR = "as-war";
    public static final String RENAMING = "renaming";
    public static final String SERVER_XML = "serverxml";
    public static final String TOMEE_XML = "tomeexml";
    public static final String PROPERTY = "property";
    public static final String SINGLE_CLASSLOADER = "single-classloader";

    public static void main(String[] args) {
        CommandLine line;
        PosixParser parser = new PosixParser();
        Options options = Main.createOptions();
        try {
            line = parser.parse(options, args, true);
        }
        catch (ParseException exp) {
            new HelpFormatter().printHelp("java -jar tomee-embedded-user.jar", options);
            return;
        }
        try {
            final Container container = new Container(Main.createConfiguration(line));
            String[] contexts = line.hasOption(CONTEXT) ? line.getOptionValues(CONTEXT) : null;
            boolean autoWar = true;
            if (line.hasOption(PATH)) {
                int i = 0;
                for (String path : line.getOptionValues(PATH)) {
                    Set locations = ProvisioningUtil.realLocation((String)path);
                    for (String location : locations) {
                        File file = new File(location);
                        if (!file.exists()) {
                            System.err.println(file.getAbsolutePath() + " does not exist, skipping");
                            continue;
                        }
                        String name = file.getName().replaceAll("\\.[A-Za-z]+$", "");
                        if (contexts != null) {
                            name = contexts[i++];
                        }
                        container.deploy(name, file, true);
                    }
                }
                autoWar = false;
            } else if (line.hasOption(AS_WAR)) {
                Main.deployClasspath(line, container, contexts);
                autoWar = false;
            } else {
                autoWar = true;
            }
            if (autoWar) {
                File me = JarLocation.jarLocation(Main.class);
                if (me.getName().endsWith(".war")) {
                    container.deploy(contexts == null || 0 == contexts.length ? "" : contexts[0], me, line.hasOption(RENAMING));
                } else {
                    Main.deployClasspath(line, container, contexts);
                }
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        container.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            container.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deployClasspath(CommandLine line, Container container, String[] contexts) {
        container.deployClasspathAsWebApp(contexts == null || 0 == contexts.length ? "" : contexts[0], line.hasOption(DOC_BASE) ? new File(line.getOptionValue(DOC_BASE)) : null, line.hasOption(SINGLE_CLASSLOADER));
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(null, PATH, true, "");
        options.addOption(null, CONTEXT, true, "Context name for applications (same order than paths)");
        options.addOption("p", PORT, true, "TomEE http port");
        options.addOption("s", SHUTDOWN, true, "TomEE shutdown port");
        options.addOption("d", DIRECTORY, true, "TomEE directory");
        options.addOption("c", AS_WAR, false, "deploy classpath as war");
        options.addOption("b", DOC_BASE, true, "when deploy classpath as war, the doc base");
        options.addOption(null, RENAMING, true, "for fat war only, is renaming of the context supported");
        options.addOption(null, SERVER_XML, true, "the server.xml path");
        options.addOption(null, TOMEE_XML, true, "the tomee.xml path");
        options.addOption(null, PROPERTY, true, "some container properties");
        return options;
    }

    private static Configuration createConfiguration(CommandLine args) {
        Configuration config = new Configuration();
        config.setHttpPort(Integer.parseInt(args.getOptionValue(PORT, "8080")));
        config.setStopPort(Integer.parseInt(args.getOptionValue(SHUTDOWN, "8005")));
        config.setDir(args.getOptionValue(DIRECTORY, new File(new File("."), "apache-tomee").getAbsolutePath()));
        if (args.hasOption(SERVER_XML)) {
            config.setServerXml(args.getOptionValue(SERVER_XML));
        }
        if (args.hasOption(TOMEE_XML)) {
            config.property("openejb.conf.file", args.getOptionValue(TOMEE_XML));
        }
        if (args.hasOption(PROPERTY)) {
            for (String opt : args.getOptionValues(PROPERTY)) {
                int sep = opt.indexOf(61);
                if (sep > 0) {
                    config.property(opt.substring(0, sep), opt.substring(sep + 1));
                    continue;
                }
                config.property(opt, "true");
            }
        }
        return config;
    }
}

