/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;
import javax.validation.ValidationException;
import org.apache.geronimo.osgi.locator.ProviderLocator;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Exceptions;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.NetworkUtil;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;

public final class EmbeddedTomEEContainer
extends EJBContainer {
    public static final String TOMEE_EJBCONTAINER_HTTP_PORT = "tomee.ejbcontainer.http.port";
    private static final AtomicReference<EmbeddedTomEEContainer> tomEEContainer = new AtomicReference();
    private static final List<String> CONTAINER_NAMES = Arrays.asList(EmbeddedTomEEContainer.class.getName(), "tomee-embedded", "embedded-tomee");
    private final Container container = new Container();
    private final Collection<String> deployedIds = new ArrayList<String>();

    private EmbeddedTomEEContainer() {
    }

    public Container getDelegate() {
        return this.container;
    }

    public void close() {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        EmbeddedTomEEContainer etc = tomEEContainer.get();
        if (null != etc) {
            for (String id : this.deployedIds) {
                if (etc.container.getAppContexts(id) == null) continue;
                try {
                    etc.container.undeploy(id);
                }
                catch (Exception ex) {
                    Logger.getInstance((LogCategory)LogCategory.OPENEJB, EmbeddedTomEEContainer.class).error(ex.getMessage(), (Throwable)ex);
                    errors.add(ex);
                }
            }
            try {
                etc.container.close();
            }
            catch (Exception ex) {
                errors.add(ex);
                Logger.getInstance((LogCategory)LogCategory.OPENEJB, EmbeddedTomEEContainer.class).error(ex.getMessage(), (Throwable)ex);
            }
        }
        this.deployedIds.clear();
        tomEEContainer.set(null);
        if (!errors.isEmpty()) {
            throw Exceptions.newEJBException((Throwable)new TomEERuntimeException(((Object)errors).toString()));
        }
    }

    public Context getContext() {
        return EmbeddedTomEEContainer.tomEEContainer.get().container.getJndiContext();
    }

    public static class EmbeddedTomEEContainerProvider
    implements EJBContainerProvider {
        public EJBContainer createEJBContainer(Map<?, ?> props) {
            HashMap properties = props == null ? new HashMap() : props;
            Object provider = properties.get("javax.ejb.embeddable.provider");
            int ejbContainerProviders = 1;
            try {
                ejbContainerProviders = ProviderLocator.getServices((String)EJBContainerProvider.class.getName(), EJBContainer.class, (ClassLoader)Thread.currentThread().getContextClassLoader()).size();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (provider == null && ejbContainerProviders > 1 || !EmbeddedTomEEContainer.class.equals(provider) && !CONTAINER_NAMES.contains(String.valueOf(provider))) {
                return null;
            }
            EmbeddedTomEEContainer etc = (EmbeddedTomEEContainer)((Object)tomEEContainer.get());
            if (etc != null) {
                return etc;
            }
            String appId = (String)properties.get("javax.ejb.embeddable.appName");
            Object modules = properties.get("javax.ejb.embeddable.modules");
            etc = new EmbeddedTomEEContainer();
            tomEEContainer.set(etc);
            Configuration configuration = new Configuration();
            if (properties.containsKey(EmbeddedTomEEContainer.TOMEE_EJBCONTAINER_HTTP_PORT)) {
                int port;
                Object portValue = properties.get(EmbeddedTomEEContainer.TOMEE_EJBCONTAINER_HTTP_PORT);
                if (portValue instanceof Integer) {
                    port = (Integer)portValue;
                } else if (portValue instanceof String) {
                    port = Integer.parseInt((String)portValue);
                } else {
                    throw new TomEERuntimeException("port value should be an integer or a string");
                }
                if (port <= 0) {
                    port = NetworkUtil.getNextAvailablePort();
                }
                configuration.setHttpPort(port);
            }
            for (Map.Entry entry : properties.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!String.class.isInstance(key) || !String.class.isInstance(value)) continue;
                configuration.property(String.valueOf(key), String.valueOf(value));
            }
            etc.container.setup(configuration);
            try {
                etc.container.start();
                System.setProperty(EmbeddedTomEEContainer.TOMEE_EJBCONTAINER_HTTP_PORT, Integer.toString(configuration.getHttpPort()));
                if (modules instanceof File) {
                    etc.deployedIds.add(etc.container.deploy(appId, (File)modules, appId != null).getId());
                } else if (modules instanceof String) {
                    etc.deployedIds.add(etc.container.deploy(appId, new File((String)modules), appId != null).getId());
                } else if (modules instanceof String[]) {
                    for (String path : (String[])modules) {
                        etc.deployedIds.add(etc.container.deploy(appId, new File(path), appId != null).getId());
                    }
                } else if (modules instanceof File[]) {
                    for (File file : (File[])modules) {
                        etc.deployedIds.add(etc.container.deploy(appId, file, appId != null).getId());
                    }
                } else {
                    SystemInstance.get().getProperties().putAll((Map<?, ?>)properties);
                    ArrayList files = etc.container.getConfigurationFactory().getModulesFromClassPath(null, Thread.currentThread().getContextClassLoader());
                    if (files.size() == 0) {
                        try {
                            etc.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        tomEEContainer.set(null);
                        throw Exceptions.newNoModulesFoundException();
                    }
                    for (File file : files) {
                        etc.deployedIds.add(etc.container.deploy(appId, file, appId != null).getId());
                    }
                }
                return etc;
            }
            catch (MalformedURLException | OpenEJBException e) {
                try {
                    etc.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                throw new EJBException((Exception)e);
            }
            catch (ValidationException ve) {
                try {
                    etc.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                throw ve;
            }
            catch (Exception e) {
                try {
                    etc.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                if (e instanceof EJBException) {
                    throw (EJBException)e;
                }
                throw new TomEERuntimeException("initialization exception", (Throwable)e);
            }
        }
    }
}

