/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.io.InputStream;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

public final class TinkerFactory {
    private TinkerFactory() {
    }

    public static TinkerGraph createClassic() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("gremlin.tinkergraph.vertexIdManager", (Object)TinkerGraph.DefaultIdManager.INTEGER.name());
        conf.setProperty("gremlin.tinkergraph.edgeIdManager", (Object)TinkerGraph.DefaultIdManager.INTEGER.name());
        conf.setProperty("gremlin.tinkergraph.vertexPropertyIdManager", (Object)TinkerGraph.DefaultIdManager.INTEGER.name());
        TinkerGraph g = TinkerGraph.open((Configuration)conf);
        TinkerFactory.generateClassic(g);
        return g;
    }

    public static void generateClassic(TinkerGraph g) {
        Vertex marko = g.addVertex(T.id, 1, "name", "marko", "age", 29);
        Vertex vadas = g.addVertex(T.id, 2, "name", "vadas", "age", 27);
        Vertex lop = g.addVertex(T.id, 3, "name", "lop", "lang", "java");
        Vertex josh = g.addVertex(T.id, 4, "name", "josh", "age", 32);
        Vertex ripple = g.addVertex(T.id, 5, "name", "ripple", "lang", "java");
        Vertex peter = g.addVertex(T.id, 6, "name", "peter", "age", 35);
        marko.addEdge("knows", vadas, new Object[]{T.id, 7, "weight", Float.valueOf(0.5f)});
        marko.addEdge("knows", josh, new Object[]{T.id, 8, "weight", Float.valueOf(1.0f)});
        marko.addEdge("created", lop, new Object[]{T.id, 9, "weight", Float.valueOf(0.4f)});
        josh.addEdge("created", ripple, new Object[]{T.id, 10, "weight", Float.valueOf(1.0f)});
        josh.addEdge("created", lop, new Object[]{T.id, 11, "weight", Float.valueOf(0.4f)});
        peter.addEdge("created", lop, new Object[]{T.id, 12, "weight", Float.valueOf(0.2f)});
    }

    public static TinkerGraph createModern() {
        TinkerGraph g = TinkerFactory.getTinkerGraphWithNumberManager();
        TinkerFactory.generateModern(g);
        return g;
    }

    public static void generateModern(TinkerGraph g) {
        Vertex marko = g.addVertex(T.id, 1, T.label, "person", "name", "marko", "age", 29);
        Vertex vadas = g.addVertex(T.id, 2, T.label, "person", "name", "vadas", "age", 27);
        Vertex lop = g.addVertex(T.id, 3, T.label, "software", "name", "lop", "lang", "java");
        Vertex josh = g.addVertex(T.id, 4, T.label, "person", "name", "josh", "age", 32);
        Vertex ripple = g.addVertex(T.id, 5, T.label, "software", "name", "ripple", "lang", "java");
        Vertex peter = g.addVertex(T.id, 6, T.label, "person", "name", "peter", "age", 35);
        marko.addEdge("knows", vadas, new Object[]{T.id, 7, "weight", 0.5});
        marko.addEdge("knows", josh, new Object[]{T.id, 8, "weight", 1.0});
        marko.addEdge("created", lop, new Object[]{T.id, 9, "weight", 0.4});
        josh.addEdge("created", ripple, new Object[]{T.id, 10, "weight", 1.0});
        josh.addEdge("created", lop, new Object[]{T.id, 11, "weight", 0.4});
        peter.addEdge("created", lop, new Object[]{T.id, 12, "weight", 0.2});
    }

    public static TinkerGraph createTheCrew() {
        Configuration conf = TinkerFactory.getNumberIdManagerConfiguration();
        conf.setProperty("gremlin.tinkergraph.defaultVertexPropertyCardinality", (Object)VertexProperty.Cardinality.list.name());
        TinkerGraph g = TinkerGraph.open(conf);
        TinkerFactory.generateTheCrew(g);
        return g;
    }

    public static void generateTheCrew(TinkerGraph g) {
        Vertex marko = g.addVertex(T.id, 1, T.label, "person", "name", "marko");
        Vertex stephen = g.addVertex(T.id, 7, T.label, "person", "name", "stephen");
        Vertex matthias = g.addVertex(T.id, 8, T.label, "person", "name", "matthias");
        Vertex daniel = g.addVertex(T.id, 9, T.label, "person", "name", "daniel");
        Vertex gremlin = g.addVertex(T.id, 10, T.label, "software", "name", "gremlin");
        Vertex tinkergraph = g.addVertex(T.id, 11, T.label, "software", "name", "tinkergraph");
        marko.property(VertexProperty.Cardinality.list, "location", (Object)"san diego", new Object[]{"startTime", 1997, "endTime", 2001});
        marko.property(VertexProperty.Cardinality.list, "location", (Object)"santa cruz", new Object[]{"startTime", 2001, "endTime", 2004});
        marko.property(VertexProperty.Cardinality.list, "location", (Object)"brussels", new Object[]{"startTime", 2004, "endTime", 2005});
        marko.property(VertexProperty.Cardinality.list, "location", (Object)"santa fe", new Object[]{"startTime", 2005});
        stephen.property(VertexProperty.Cardinality.list, "location", (Object)"centreville", new Object[]{"startTime", 1990, "endTime", 2000});
        stephen.property(VertexProperty.Cardinality.list, "location", (Object)"dulles", new Object[]{"startTime", 2000, "endTime", 2006});
        stephen.property(VertexProperty.Cardinality.list, "location", (Object)"purcellville", new Object[]{"startTime", 2006});
        matthias.property(VertexProperty.Cardinality.list, "location", (Object)"bremen", new Object[]{"startTime", 2004, "endTime", 2007});
        matthias.property(VertexProperty.Cardinality.list, "location", (Object)"baltimore", new Object[]{"startTime", 2007, "endTime", 2011});
        matthias.property(VertexProperty.Cardinality.list, "location", (Object)"oakland", new Object[]{"startTime", 2011, "endTime", 2014});
        matthias.property(VertexProperty.Cardinality.list, "location", (Object)"seattle", new Object[]{"startTime", 2014});
        daniel.property(VertexProperty.Cardinality.list, "location", (Object)"spremberg", new Object[]{"startTime", 1982, "endTime", 2005});
        daniel.property(VertexProperty.Cardinality.list, "location", (Object)"kaiserslautern", new Object[]{"startTime", 2005, "endTime", 2009});
        daniel.property(VertexProperty.Cardinality.list, "location", (Object)"aachen", new Object[]{"startTime", 2009});
        marko.addEdge("develops", gremlin, new Object[]{T.id, 13, "since", 2009});
        marko.addEdge("develops", tinkergraph, new Object[]{T.id, 14, "since", 2010});
        marko.addEdge("uses", gremlin, new Object[]{T.id, 15, "skill", 4});
        marko.addEdge("uses", tinkergraph, new Object[]{T.id, 16, "skill", 5});
        stephen.addEdge("develops", gremlin, new Object[]{T.id, 17, "since", 2010});
        stephen.addEdge("develops", tinkergraph, new Object[]{T.id, 18, "since", 2011});
        stephen.addEdge("uses", gremlin, new Object[]{T.id, 19, "skill", 5});
        stephen.addEdge("uses", tinkergraph, new Object[]{T.id, 20, "skill", 4});
        matthias.addEdge("develops", gremlin, new Object[]{T.id, 21, "since", 2012});
        matthias.addEdge("uses", gremlin, new Object[]{T.id, 22, "skill", 3});
        matthias.addEdge("uses", tinkergraph, new Object[]{T.id, 23, "skill", 3});
        daniel.addEdge("uses", gremlin, new Object[]{T.id, 24, "skill", 5});
        daniel.addEdge("uses", tinkergraph, new Object[]{T.id, 25, "skill", 3});
        gremlin.addEdge("traverses", tinkergraph, new Object[]{T.id, 26});
        g.variables().set("creator", (Object)"marko");
        g.variables().set("lastModified", (Object)2014);
        g.variables().set("comment", (Object)"this graph was created to provide examples and test coverage for tinkerpop3 api advances");
    }

    public static TinkerGraph createKitchenSink() {
        TinkerGraph g = TinkerFactory.getTinkerGraphWithNumberManager();
        TinkerFactory.generateKitchenSink(g);
        return g;
    }

    public static void generateKitchenSink(TinkerGraph graph) {
        GraphTraversalSource g = graph.traversal();
        g.addV("loops").property((Object)T.id, (Object)1000, new Object[0]).property((Object)"name", (Object)"loop", new Object[0]).as("me", new String[0]).addE("self").to("me").property((Object)T.id, (Object)1001, new Object[0]).iterate();
        g.addV("message").property((Object)T.id, (Object)2000, new Object[0]).property((Object)"name", (Object)"a", new Object[0]).as("a", new String[0]).addV("message").property((Object)T.id, (Object)2001, new Object[0]).property((Object)"name", (Object)"b", new Object[0]).as("b", new String[0]).addE("link").from("a").to("b").property((Object)T.id, (Object)2002, new Object[0]).addE("link").from("a").to("a").property((Object)T.id, (Object)2003, new Object[0]).iterate();
    }

    public static TinkerGraph createGratefulDead() {
        TinkerGraph g = TinkerFactory.getTinkerGraphWithNumberManager();
        TinkerFactory.generateGratefulDead(g);
        return g;
    }

    public static void generateGratefulDead(TinkerGraph graph) {
        InputStream stream = TinkerFactory.class.getResourceAsStream("grateful-dead.kryo");
        try {
            ((GryoIo)graph.io(IoCore.gryo())).reader().create().readGraph(stream, (Graph)graph);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static TinkerGraph getTinkerGraphWithNumberManager() {
        Configuration conf = TinkerFactory.getNumberIdManagerConfiguration();
        return TinkerGraph.open(conf);
    }

    private static Configuration getNumberIdManagerConfiguration() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("gremlin.tinkergraph.vertexIdManager", (Object)TinkerGraph.DefaultIdManager.INTEGER.name());
        conf.setProperty("gremlin.tinkergraph.edgeIdManager", (Object)TinkerGraph.DefaultIdManager.INTEGER.name());
        conf.setProperty("gremlin.tinkergraph.vertexPropertyIdManager", (Object)TinkerGraph.DefaultIdManager.LONG.name());
        return conf;
    }
}

