/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.plugin;

public class Artifact {
    private final String group;
    private final String artifact;
    private final String version;

    public Artifact(String group, String artifact, String version) {
        if (group == null || group.isEmpty()) {
            throw new IllegalArgumentException("group cannot be null or empty");
        }
        if (artifact == null || artifact.isEmpty()) {
            throw new IllegalArgumentException("artifact cannot be null or empty");
        }
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("version cannot be null or empty");
        }
        this.group = group;
        this.artifact = artifact;
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact a = (Artifact)o;
        if (this.group != null ? !this.group.equals(a.group) : a.group != null) {
            return false;
        }
        if (this.artifact != null ? !this.artifact.equals(a.artifact) : a.artifact != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(a.version) : a.version != null);
    }

    public int hashCode() {
        int result = this.group != null ? this.group.hashCode() : 0;
        result = 31 * result + (this.artifact != null ? this.artifact.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }
}

