/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import java.util.Collections;
import java.util.List;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.Customizer;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineFactory;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.util.Gremlin;

public class GremlinGroovyScriptEngineFactory
implements GremlinScriptEngineFactory {
    private static final String ENGINE_NAME = "gremlin-groovy";
    private static final String LANGUAGE_NAME = "gremlin-groovy";
    private static final String PLAIN = "plain";
    private static final List<String> EXTENSIONS = Collections.singletonList("groovy");
    private GremlinScriptEngineManager manager;

    public void setCustomizerManager(GremlinScriptEngineManager manager) {
        this.manager = manager;
    }

    public String getEngineName() {
        return "gremlin-groovy";
    }

    public String getEngineVersion() {
        return Gremlin.version();
    }

    public List<String> getExtensions() {
        return EXTENSIONS;
    }

    public String getLanguageName() {
        return "gremlin-groovy";
    }

    public String getLanguageVersion() {
        return Gremlin.version();
    }

    public String getMethodCallSyntax(String obj, String m, String ... args) {
        return null;
    }

    public List<String> getMimeTypes() {
        return Collections.singletonList(PLAIN);
    }

    public List<String> getNames() {
        return Collections.singletonList("gremlin-groovy");
    }

    public String getOutputStatement(String toDisplay) {
        return "println " + toDisplay;
    }

    public Object getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.name")) {
            return "gremlin-groovy";
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        return null;
    }

    public String getProgram(String ... statements) {
        String program = "";
        for (String statement : statements) {
            program = program + statement + "\n";
        }
        return program;
    }

    public GremlinScriptEngine getScriptEngine() {
        List customizers = this.manager.getCustomizers("gremlin-groovy");
        return customizers.isEmpty() ? new GremlinGroovyScriptEngine() : new GremlinGroovyScriptEngine(customizers.toArray(new Customizer[customizers.size()]));
    }
}

